/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForSmartCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "alarm", "Lcom/intellij/util/Alarm;", "completeWhenSmartModeIsLongEnough", "", "project", "Lcom/intellij/openapi/project/Project;", "completion", "Lkotlinx/coroutines/CompletableDeferred;", "doExecute", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.performanceTesting"})
public final class WaitForSmartCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Alarm alarm;
    @NotNull
    public static final String PREFIX = "%waitForSmart";
    private static final int SMART_MODE_MINIMUM_DELAY = 3000;

    public WaitForSmartCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
        this.alarm = new Alarm();
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        CompletableDeferred completion = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.completeWhenSmartModeIsLongEnough(project, (CompletableDeferred<Unit>)completion);
        Object object = completion.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void completeWhenSmartModeIsLongEnough(Project project, CompletableDeferred<Unit> completion) {
        DumbService.Companion.getInstance(project).runWhenSmart(() -> WaitForSmartCommand.completeWhenSmartModeIsLongEnough$lambda$1(this, project, completion));
    }

    private static final void completeWhenSmartModeIsLongEnough$lambda$1$lambda$0(Project $project, WaitForSmartCommand this$0, CompletableDeferred $completion) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        if (DumbService.Companion.isDumb($project)) {
            this$0.completeWhenSmartModeIsLongEnough($project, (CompletableDeferred<Unit>)$completion);
        } else {
            $completion.complete((Object)Unit.INSTANCE);
        }
    }

    private static final void completeWhenSmartModeIsLongEnough$lambda$1(WaitForSmartCommand this$0, Project $project, CompletableDeferred $completion) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        this$0.alarm.addRequest(() -> WaitForSmartCommand.completeWhenSmartModeIsLongEnough$lambda$1$lambda$0($project, this$0, $completion), 3000);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForSmartCommand$Companion;", "", "()V", "PREFIX", "", "SMART_MODE_MINIMUM_DELAY", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

