/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import org.assertj.swing.core.BasicRobot;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.WindowDriver;
import org.assertj.swing.fixture.AbstractContainerFixture;
import org.assertj.swing.fixture.JPopupMenuFixture;
import org.assertj.swing.fixture.JPopupMenuInvokerFixture;
import org.assertj.swing.fixture.WindowLikeContainerFixture;

public abstract class AbstractWindowFixture<S, C extends Window, D extends WindowDriver>
extends AbstractContainerFixture<S, C, D>
implements WindowLikeContainerFixture<S>,
JPopupMenuInvokerFixture {
    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nonnull Class<? extends C> type2) {
        this(selfType, BasicRobot.robotWithCurrentAwtHierarchy(), type2);
    }

    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type2) {
        super(selfType, robot, type2);
    }

    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nullable String name, @Nonnull Class<? extends C> type2) {
        this(selfType, BasicRobot.robotWithCurrentAwtHierarchy(), name, type2);
    }

    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type2) {
        super(selfType, robot, name, type2);
    }

    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nonnull C target) {
        this(selfType, BasicRobot.robotWithCurrentAwtHierarchy(), target);
    }

    public AbstractWindowFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        super(selfType, robot, target);
    }

    @Override
    @Nonnull
    public final S moveTo(@Nonnull Point p) {
        ((WindowDriver)this.driver()).moveTo((Window)this.target(), p);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S moveToFront() {
        ((WindowDriver)this.driver()).moveToFront((Window)this.target());
        return this.myself();
    }

    @Override
    @Nonnull
    public final S moveToBack() {
        ((WindowDriver)this.driver()).moveToBack((Window)this.target());
        return this.myself();
    }

    @Override
    @Nonnull
    public final S requireSize(@Nonnull Dimension size) {
        ((WindowDriver)this.driver()).requireSize((Component)this.target(), size);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S resizeHeightTo(int height) {
        ((WindowDriver)this.driver()).resizeHeightTo((Window)this.target(), height);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S resizeTo(@Nonnull Dimension size) {
        ((WindowDriver)this.driver()).resizeTo((Window)this.target(), size);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S resizeWidthTo(int width) {
        ((WindowDriver)this.driver()).resizeWidthTo((Window)this.target(), width);
        return this.myself();
    }

    @Nonnull
    public final S show() {
        ((WindowDriver)this.driver()).show((Window)this.target());
        return this.myself();
    }

    @Nonnull
    public final S show(@Nonnull Dimension size) {
        ((WindowDriver)this.driver()).show((Window)this.target(), size);
        return this.myself();
    }

    @Override
    @Nonnull
    public final JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot(), ((WindowDriver)this.driver()).invokePopupMenu((Component)this.target()));
    }

    @Override
    @Nonnull
    public final JPopupMenuFixture showPopupMenuAt(@Nonnull Point p) {
        return new JPopupMenuFixture(this.robot(), ((WindowDriver)this.driver()).invokePopupMenu((Component)this.target(), p));
    }

    @Override
    public final void close() {
        ((WindowDriver)this.driver()).close((Window)this.target());
    }

    public final void cleanUp() {
        this.robot().cleanUp();
    }
}

