/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JList;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class JListItemPreconditions {
    @RunsInCurrentThread
    static void checkIndexInBounds(@Nonnull JList<?> list2, int index) {
        JListItemPreconditions.checkIndexInBounds(index, list2.getModel().getSize());
    }

    @RunsInCurrentThread
    static void checkIndicesInBounds(@Nonnull JList<?> list2, int ... indices) {
        int itemCount = list2.getModel().getSize();
        for (int index : indices) {
            JListItemPreconditions.checkIndexInBounds(index, itemCount);
        }
    }

    private static void checkIndexInBounds(int index, int itemCount) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        String format = "Item index (%d) should be between [0] and [%d] (inclusive)";
        String msg = String.format(format, index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private JListItemPreconditions() {
    }
}

