/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.DualValue;

class VisitedDualValues {
    private List<VisitedDualValue> dualValues = new ArrayList<VisitedDualValue>();

    VisitedDualValues() {
    }

    void registerVisitedDualValue(DualValue dualValue) {
        this.dualValues.add(new VisitedDualValue(dualValue));
    }

    void registerComparisonDifference(DualValue dualValue, ComparisonDifference comparisonDifference) {
        this.dualValues.stream().filter(visitedDualValue -> visitedDualValue.dualValue.sameValues(dualValue)).findFirst().ifPresent(visitedDualValue -> visitedDualValue.comparisonDifferences.add(comparisonDifference));
    }

    Optional<List<ComparisonDifference>> registeredComparisonDifferencesOf(DualValue dualValue) {
        return this.dualValues.stream().filter(visitedDualValue -> visitedDualValue.dualValue.sameValues(dualValue)).findFirst().map(visitedDualValue -> visitedDualValue.comparisonDifferences);
    }

    private static class VisitedDualValue {
        DualValue dualValue;
        List<ComparisonDifference> comparisonDifferences;

        VisitedDualValue(DualValue dualValue) {
            this.dualValue = dualValue;
            this.comparisonDifferences = new ArrayList<ComparisonDifference>();
        }

        public String toString() {
            return String.format("VisitedDualValue[dualValue=%s, comparisonDifferences=%s]", this.dualValue, this.comparisonDifferences);
        }
    }
}

