/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10383")
final class PickFirstLeafLoadBalancer
extends LoadBalancer {
    private static final Logger log = Logger.getLogger(PickFirstLeafLoadBalancer.class.getName());
    private final LoadBalancer.Helper helper;
    private final Map<SocketAddress, SubchannelData> subchannels = new HashMap<SocketAddress, SubchannelData>();
    private Index addressIndex;
    private ConnectivityState rawConnectivityState = ConnectivityState.IDLE;
    private ConnectivityState concludedState = ConnectivityState.IDLE;

    PickFirstLeafLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
        if (servers.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        for (EquivalentAddressGroup eag : servers) {
            if (eag != null) continue;
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned address list with null endpoint. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        if (resolvedAddresses.getLoadBalancingPolicyConfig() instanceof PickFirstLeafLoadBalancerConfig) {
            PickFirstLeafLoadBalancerConfig config = (PickFirstLeafLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            if (config.shuffleAddressList != null && config.shuffleAddressList.booleanValue()) {
                servers = new ArrayList<EquivalentAddressGroup>(servers);
                Collections.shuffle(servers, config.randomSeed != null ? new Random(config.randomSeed) : new Random());
            }
        }
        List<EquivalentAddressGroup> newImmutableAddressGroups = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(servers));
        if (this.addressIndex == null) {
            this.addressIndex = new Index(newImmutableAddressGroups);
        } else if (this.rawConnectivityState == ConnectivityState.READY) {
            SocketAddress previousAddress = this.addressIndex.getCurrentAddress();
            this.addressIndex.updateGroups(newImmutableAddressGroups);
            if (this.addressIndex.seekTo(previousAddress)) {
                return Status.OK;
            }
            this.addressIndex.reset();
        } else {
            this.addressIndex.updateGroups(newImmutableAddressGroups);
        }
        HashSet<SocketAddress> oldAddrs = new HashSet<SocketAddress>(this.subchannels.keySet());
        HashSet<SocketAddress> newAddrs = new HashSet<SocketAddress>();
        for (EquivalentAddressGroup endpoint : newImmutableAddressGroups) {
            for (SocketAddress addr : endpoint.getAddresses()) {
                newAddrs.add(addr);
                if (this.subchannels.containsKey(addr)) continue;
                this.createNewSubchannel(addr);
            }
        }
        for (SocketAddress oldAddr : oldAddrs) {
            if (newAddrs.contains(oldAddr)) continue;
            this.subchannels.get(oldAddr).getSubchannel().shutdown();
            this.subchannels.remove(oldAddr);
        }
        if (oldAddrs.size() == 0 || this.rawConnectivityState == ConnectivityState.CONNECTING || this.rawConnectivityState == ConnectivityState.READY) {
            this.rawConnectivityState = ConnectivityState.CONNECTING;
            this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
            this.requestConnection();
        } else if (this.rawConnectivityState == ConnectivityState.IDLE) {
            RequestConnectionPicker picker = new RequestConnectionPicker(this);
            this.updateBalancingState(ConnectivityState.IDLE, picker);
        } else if (this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE) {
            this.requestConnection();
        }
        return Status.OK;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(error)));
    }

    void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        ConnectivityState newState = stateInfo.getState();
        SubchannelData subchannelData = this.subchannels.get(this.getAddress(subchannel));
        if (subchannelData == null || subchannelData.getSubchannel() != subchannel) {
            return;
        }
        if (newState == ConnectivityState.SHUTDOWN) {
            return;
        }
        if (newState == ConnectivityState.IDLE) {
            this.helper.refreshNameResolution();
        }
        subchannelData.updateState(newState);
        if (this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE || this.concludedState == ConnectivityState.TRANSIENT_FAILURE) {
            if (newState == ConnectivityState.CONNECTING) {
                return;
            }
            if (newState == ConnectivityState.IDLE) {
                this.requestConnection();
                return;
            }
        }
        switch (newState) {
            case IDLE: {
                this.addressIndex.reset();
                this.rawConnectivityState = ConnectivityState.IDLE;
                this.updateBalancingState(ConnectivityState.IDLE, new RequestConnectionPicker(this));
                break;
            }
            case CONNECTING: {
                this.rawConnectivityState = ConnectivityState.CONNECTING;
                this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
                break;
            }
            case READY: {
                this.shutdownRemaining(subchannelData);
                this.addressIndex.seekTo(this.getAddress(subchannel));
                this.rawConnectivityState = ConnectivityState.READY;
                this.updateHealthCheckedState(subchannelData);
                break;
            }
            case TRANSIENT_FAILURE: {
                if (!this.addressIndex.isValid() || this.subchannels.get(this.addressIndex.getCurrentAddress()).getSubchannel() != subchannel) break;
                this.addressIndex.increment();
                this.requestConnection();
                if (this.addressIndex.isValid()) break;
                this.helper.refreshNameResolution();
                this.rawConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(stateInfo.getStatus())));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)newState));
            }
        }
    }

    private void updateHealthCheckedState(SubchannelData subchannelData) {
        if (subchannelData.state != ConnectivityState.READY) {
            return;
        }
        if (subchannelData.getHealthState() == ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.READY, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withSubchannel(subchannelData.subchannel)));
        } else if (subchannelData.getHealthState() == ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(subchannelData.healthListener.healthStateInfo.getStatus())));
        } else if (this.concludedState != ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(subchannelData.getHealthState(), new Picker(LoadBalancer.PickResult.withNoResult()));
        }
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state == this.concludedState && (state == ConnectivityState.IDLE || state == ConnectivityState.CONNECTING)) {
            return;
        }
        this.concludedState = state;
        this.helper.updateBalancingState(state, picker);
    }

    @Override
    public void shutdown() {
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
    }

    private void shutdownRemaining(SubchannelData activeSubchannelData) {
        for (SubchannelData subchannelData : this.subchannels.values()) {
            if (subchannelData.getSubchannel().equals(activeSubchannelData.subchannel)) continue;
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        activeSubchannelData.updateState(ConnectivityState.READY);
        this.subchannels.put(this.getAddress(activeSubchannelData.subchannel), activeSubchannelData);
    }

    @Override
    public void requestConnection() {
        if (this.subchannels.size() == 0) {
            return;
        }
        if (this.addressIndex.isValid()) {
            LoadBalancer.Subchannel subchannel = this.subchannels.containsKey(this.addressIndex.getCurrentAddress()) ? this.subchannels.get(this.addressIndex.getCurrentAddress()).getSubchannel() : this.createNewSubchannel(this.addressIndex.getCurrentAddress());
            ConnectivityState subchannelState = this.subchannels.get(this.addressIndex.getCurrentAddress()).getState();
            if (subchannelState == ConnectivityState.IDLE) {
                subchannel.requestConnection();
            } else if (subchannelState == ConnectivityState.CONNECTING || subchannelState == ConnectivityState.TRANSIENT_FAILURE) {
                this.addressIndex.increment();
                this.requestConnection();
            }
        }
    }

    private LoadBalancer.Subchannel createNewSubchannel(SocketAddress addr) {
        HealthListener hcListener = new HealthListener();
        final LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(Lists.newArrayList((Object[])new EquivalentAddressGroup[]{new EquivalentAddressGroup(addr)})).addOption(HEALTH_CONSUMER_LISTENER_ARG_KEY, hcListener).build());
        SubchannelData subchannelData = new SubchannelData(subchannel, ConnectivityState.IDLE, hcListener);
        hcListener.subchannelData = subchannelData;
        this.subchannels.put(addr, subchannelData);
        Attributes attrs = subchannel.getAttributes();
        if (attrs.get(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY) == null) {
            hcListener.healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.READY);
        }
        subchannel.start(new LoadBalancer.SubchannelStateListener(){

            @Override
            public void onSubchannelState(ConnectivityStateInfo stateInfo) {
                PickFirstLeafLoadBalancer.this.processSubchannelState(subchannel, stateInfo);
            }
        });
        return subchannel;
    }

    private SocketAddress getAddress(LoadBalancer.Subchannel subchannel) {
        return subchannel.getAddresses().getAddresses().get(0);
    }

    @VisibleForTesting
    ConnectivityState getConcludedConnectivityState() {
        return this.concludedState;
    }

    public static final class PickFirstLeafLoadBalancerConfig {
        @Nullable
        public final Boolean shuffleAddressList;
        @Nullable
        final Long randomSeed;

        public PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList) {
            this(shuffleAddressList, null);
        }

        PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList, @Nullable Long randomSeed) {
            this.shuffleAddressList = shuffleAddressList;
            this.randomSeed = randomSeed;
        }
    }

    private static final class SubchannelData {
        private final LoadBalancer.Subchannel subchannel;
        private ConnectivityState state;
        private final HealthListener healthListener;

        public SubchannelData(LoadBalancer.Subchannel subchannel, ConnectivityState state, HealthListener subchannelHealthListener) {
            this.subchannel = subchannel;
            this.state = state;
            this.healthListener = subchannelHealthListener;
        }

        public LoadBalancer.Subchannel getSubchannel() {
            return this.subchannel;
        }

        public ConnectivityState getState() {
            return this.state;
        }

        private void updateState(ConnectivityState newState) {
            this.state = newState;
        }

        private ConnectivityState getHealthState() {
            return this.healthListener.healthStateInfo.getState();
        }
    }

    @VisibleForTesting
    static final class Index {
        private List<EquivalentAddressGroup> addressGroups;
        private int groupIndex;
        private int addressIndex;

        public Index(List<EquivalentAddressGroup> groups) {
            this.addressGroups = groups;
        }

        public boolean isValid() {
            return this.groupIndex < this.addressGroups.size();
        }

        public boolean isAtBeginning() {
            return this.groupIndex == 0 && this.addressIndex == 0;
        }

        public void increment() {
            EquivalentAddressGroup group = this.addressGroups.get(this.groupIndex);
            ++this.addressIndex;
            if (this.addressIndex >= group.getAddresses().size()) {
                ++this.groupIndex;
                this.addressIndex = 0;
            }
        }

        public void reset() {
            this.groupIndex = 0;
            this.addressIndex = 0;
        }

        public SocketAddress getCurrentAddress() {
            return this.addressGroups.get(this.groupIndex).getAddresses().get(this.addressIndex);
        }

        public Attributes getCurrentEagAttributes() {
            return this.addressGroups.get(this.groupIndex).getAttributes();
        }

        public List<EquivalentAddressGroup> getGroups() {
            return this.addressGroups;
        }

        public void updateGroups(List<EquivalentAddressGroup> newGroups) {
            this.addressGroups = newGroups;
            this.reset();
        }

        public boolean seekTo(SocketAddress needle) {
            for (int i = 0; i < this.addressGroups.size(); ++i) {
                EquivalentAddressGroup group = this.addressGroups.get(i);
                int j = group.getAddresses().indexOf(needle);
                if (j == -1) continue;
                this.groupIndex = i;
                this.addressIndex = j;
                return true;
            }
            return false;
        }
    }

    private final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        RequestConnectionPicker(PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer2) {
            this.pickFirstLeafLoadBalancer = (PickFirstLeafLoadBalancer)Preconditions.checkNotNull((Object)pickFirstLeafLoadBalancer2, (Object)"pickFirstLeafLoadBalancer");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                PickFirstLeafLoadBalancer.this.helper.getSynchronizationContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        RequestConnectionPicker.this.pickFirstLeafLoadBalancer.requestConnection();
                    }
                });
            }
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = (LoadBalancer.PickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(Picker.class).add("result", (Object)this.result).toString();
        }
    }

    private final class HealthListener
    implements LoadBalancer.SubchannelStateListener {
        private ConnectivityStateInfo healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
        private SubchannelData subchannelData;

        private HealthListener() {
        }

        @Override
        public void onSubchannelState(ConnectivityStateInfo newState) {
            log.log(Level.FINE, "Received health status {0} for subchannel {1}", new Object[]{newState, this.subchannelData.subchannel});
            this.healthStateInfo = newState;
            if (PickFirstLeafLoadBalancer.this.addressIndex.isValid() && ((SubchannelData)PickFirstLeafLoadBalancer.this.subchannels.get(PickFirstLeafLoadBalancer.this.addressIndex.getCurrentAddress())).healthListener == this) {
                PickFirstLeafLoadBalancer.this.updateHealthCheckedState(this.subchannelData);
            }
        }
    }
}

