/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventIdName;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\b\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000fH\u0016J)\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\b\u0019J(\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f0\u001aJ1\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fJ'\u0010\u0012\u001a\u00020\u00132\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fJ\"\u0010\u001d\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fJ'\u0010\u001e\u001a\u00020\u001f2\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010 J\u0018\u0010\u001e\u001a\u00020\u001f2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fR\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "description", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)V", "", "buildUsageData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "pairs", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "getFields", "log", "", "project", "Lcom/intellij/openapi/project/Project;", "dataBuilder", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/events/EventDataCollector;", "Lkotlin/ExtensionFunctionType;", "Ljava/util/function/Consumer;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "logState", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.platform.statistics"})
public final class VarargEventId
extends BaseEventId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventLogGroup group;
    @NotNull
    private final List<EventField<?>> fields;
    @NotNull
    private static final Logger LOG;

    public VarargEventId(@NotNull EventLogGroup group, @EventIdName @NonNls @NotNull String eventId, @NonNls @Nullable String description, EventField<?> ... fields) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super(eventId, group.getRecorder(), description);
        this.group = group;
        this.fields = ArraysKt.toMutableList((Object[])fields);
    }

    public final void log(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(pairs).build(), false);
    }

    public final void log(@Nullable Project project, EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(project, CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@Nullable Project project, @NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(pairs).addProject(project).build(), false);
    }

    public final void log(@Nullable Project project, @NotNull Consumer<List<EventPair<?>>> dataBuilder) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        this.log(project, (Function1<? super EventDataCollector, Unit>)new Function1<List<? extends EventPair<?>>, Unit>(dataBuilder){

            public final void invoke(@NotNull List<? extends EventPair<?>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((Consumer)this.receiver).accept(p0);
            }
        });
    }

    public final void log(@Nullable Project project, @NotNull Function1<? super EventDataCollector, Unit> dataBuilder) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), (Function0<? extends Map<String, ? extends Object>>)((Function0)new Function0<Map<String, ? extends Object>>(dataBuilder, this, project){
            final /* synthetic */ Function1<EventDataCollector, Unit> $dataBuilder;
            final /* synthetic */ VarargEventId this$0;
            final /* synthetic */ Project $project;
            {
                this.$dataBuilder = $dataBuilder;
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final Map<String, Object> invoke() {
                EventDataCollector list = new EventDataCollector();
                this.$dataBuilder.invoke((Object)list);
                return !list.getSkipped() ? VarargEventId.access$buildUsageData(this.this$0, list).addProject(this.$project).build() : null;
            }
        }), false);
    }

    public final void logState(@Nullable Project project, @NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(pairs).addProject(project).build(), true);
    }

    @NotNull
    public final MetricEvent metric(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return this.metric(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    @NotNull
    public final MetricEvent metric(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return new MetricEvent(this.getEventId(), this.buildUsageData(pairs), this.group.getRecorder());
    }

    private final FeatureUsageData buildUsageData(List<? extends EventPair<?>> pairs) {
        FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
        for (EventPair<?> pair : pairs) {
            if (!this.fields.contains(pair.getField())) {
                throw new IllegalArgumentException("Field " + pair.getField().getName() + " not in fields for event ID " + this.getEventId());
            }
            EventField<?> eventField = pair.getField();
            Intrinsics.checkNotNull(eventField, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.events.EventField<kotlin.Any?>");
            eventField.addData(data, pair.getData());
        }
        return data;
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        return CollectionsKt.toList((Iterable)this.fields);
    }

    public static final /* synthetic */ FeatureUsageData access$buildUsageData(VarargEventId $this, List pairs) {
        return $this.buildUsageData(pairs);
    }

    static {
        Logger logger = Logger.getInstance(VarargEventId.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/VarargEventId$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

