/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DefaultEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFileWriter;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016R*\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "recorderId", "", "loggerProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "maxFileSizeInBytes", "", "isEap", "", "prefix", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;IZLjava/lang/String;)V", "value", "Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;", "logger", "getLogger", "()Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;", "setLogger", "(Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;)V", "cleanup", "", "dispose", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getEventLogDir", "Ljava/nio/file/Path;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rollOver", "intellij.platform.statistics"})
public final class StatisticsEventLogFileWriter
implements StatisticsEventLogWriter {
    @NotNull
    private final String recorderId;
    @NotNull
    private final StatisticsEventLoggerProvider loggerProvider;
    @Nullable
    private EventLogFileWriter logger;

    public StatisticsEventLogFileWriter(@NotNull String recorderId, @NotNull StatisticsEventLoggerProvider loggerProvider, int maxFileSizeInBytes, boolean isEap, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)loggerProvider, (String)"loggerProvider");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.recorderId = recorderId;
        this.loggerProvider = loggerProvider;
        try {
            Path dir = this.getEventLogDir();
            EventLogBuildType buildType = isEap ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
            Function1 logFilePathProvider2 = (Function1)new Function1<Path, File>(buildType, prefix){
                final /* synthetic */ EventLogBuildType $buildType;
                final /* synthetic */ String $prefix;
                {
                    this.$buildType = $buildType;
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final File invoke(@NotNull Path directory) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    return EventLogFile.Companion.create(directory, this.$buildType, this.$prefix).getFile();
                }
            };
            EventLogFileWriter fileEventLoggerLogger = new EventLogFileWriter(dir, maxFileSizeInBytes, logFilePathProvider2, 0L, 8, null);
            this.setLogger(fileEventLoggerLogger);
            if (StatisticsRecorderUtil.isTestModeEnabled(this.recorderId)) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> StatisticsEventLogFileWriter._init_$lambda$0(this, fileEventLoggerLogger), 10L, TimeUnit.SECONDS);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }

    private final EventLogFileWriter getLogger() {
        return this.loggerProvider.isRecordEnabled() ? this.logger : null;
    }

    private final void setLogger(EventLogFileWriter value) {
        EventLogFileWriter eventLogFileWriter = this.logger;
        if (eventLogFileWriter != null) {
            eventLogFileWriter.close();
        }
        this.logger = value;
    }

    private final Path getEventLogDir() {
        Path path = EventLogConfiguration.Companion.getInstance().getEventLogDataPath().resolve("logs").resolve(this.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
            EventLogFileWriter eventLogFileWriter = this.getLogger();
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.log(LogEventSerializer.INSTANCE.toString(logEvent));
        }
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        Object object = this.getLogger();
        if (object == null || (object = ((EventLogFileWriter)object).getActiveLogName()) == null) {
            return null;
        }
        Object activeLog = object;
        return new EventLogFile(new File(new File(this.getEventLogDir().toUri()), (String)activeLog));
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return new DefaultEventLogFilesProvider(this.getEventLogDir(), (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ StatisticsEventLogFileWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                EventLogFileWriter eventLogFileWriter = StatisticsEventLogFileWriter.access$getLogger(this.this$0);
                return eventLogFileWriter != null ? eventLogFileWriter.getActiveLogName() : null;
            }
        }));
    }

    @Override
    public void cleanup() {
        block0: {
            EventLogFileWriter eventLogFileWriter = this.getLogger();
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.cleanUp();
        }
    }

    @Override
    public void rollOver() {
        block0: {
            EventLogFileWriter eventLogFileWriter = this.getLogger();
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.rollOver();
        }
    }

    public void dispose() {
        Future<?> closeFuture = AppExecutorUtil.getAppExecutorService().submit(() -> StatisticsEventLogFileWriter.dispose$lambda$1(this));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> StatisticsEventLogFileWriter.dispose$lambda$2(closeFuture)));
    }

    private static final void _init_$lambda$0(StatisticsEventLogFileWriter this$0, EventLogFileWriter $fileEventLoggerLogger) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileEventLoggerLogger, (String)"$fileEventLoggerLogger");
        if (this$0.loggerProvider.isRecordEnabled()) {
            $fileEventLoggerLogger.flush();
        }
    }

    private static final void dispose$lambda$1(StatisticsEventLogFileWriter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setLogger(null);
    }

    private static final void dispose$lambda$2(Future $closeFuture) {
        $closeFuture.get(500L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ EventLogFileWriter access$getLogger(StatisticsEventLogFileWriter $this) {
        return $this.getLogger();
    }
}

