/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ssh.ui.unified.SshConnectionConfigPatchForm;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsEditorBase<T extends MutableRemoteCredentials>
extends SettingsEditor<T>
implements PanelWithAnchor {
    protected JPanel myMainPanel;
    protected JBLabel myHostLabel;
    protected JBLabel myPasswordLabel;
    protected JBCheckBox mySavePasswordCheckBox;
    protected JBTextField myUsernameField;
    @NonNls
    protected TextFieldWithBrowseButton myPrivateKeyFileField;
    protected JBLabel myPassphraseLabel;
    protected JPasswordField myPassphraseField;
    protected JCheckBox mySavePassphraseCheckbox;
    protected JPasswordField myPasswordField;
    protected JBLabel myPrivateKeyFileLabel;
    protected JComboBox<AuthType> myAuthTypeCombo;
    @NonNls
    protected JBTextField myHostField;
    protected JBTextField myPortField;
    protected JButton myTestButton;
    private JCheckBox myParseConfigCheckBox;
    private JPanel myConnectionConfigPatchPanel;
    private JBLabel mySavedPasswordLabel;
    private HyperlinkLabel myResetPasswordLabel;
    private JPanel myProvidedPasswordPanel;
    private JPanel myProvidedPassphrasePanel;
    private JBLabel mySavedPassphraseLabel;
    private HyperlinkLabel myResetPassphraseLabel;
    private final PasswordGroup myPasswordGroup;
    private final PasswordGroup myPassphraseGroup;
    private final Map<String, JComponent> myField2Component;
    private RemoteSdkEditorContainer myContainer;
    @Nullable
    private final SingleAlarm myUpdateAlarm;
    @Nullable
    private JComponent myAnchor;
    private SshConnectionConfigPatchForm myConnectionConfigPatchForm;

    public SshCredentialsEditorBase(boolean showTestButton, final boolean focusPassField, @Nullable Disposable parent) {
        this.$$$setupUI$$$();
        if (parent == null) {
            this.myUpdateAlarm = null;
        } else {
            this.myUpdateAlarm = new SingleAlarm(this::updateAlarmCallback, 100, parent, Alarm.ThreadToUse.SWING_THREAD, ModalityState.any());
            this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SshCredentialsEditorBase.this.myUpdateAlarm.cancelAndRequest();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/SshCredentialsEditorBase$1", "textChanged"));
                }
            });
        }
        this.myPrivateKeyFileLabel.setLabelFor((Component)this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SshCredentialsEditorBase.this.updateNeedsPassphrase();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/SshCredentialsEditorBase$2", "textChanged"));
            }
        });
        this.myPrivateKeyFileField.addActionListener(SshUIUtil.createBrowseListenerForPrivateKey(this.myPrivateKeyFileField));
        this.myAuthTypeCombo.setModel((ComboBoxModel<AuthType>)new CollectionComboBoxModel(Arrays.asList(AuthType.PASSWORD, AuthType.KEY_PAIR, AuthType.OPEN_SSH), (Object)AuthType.PASSWORD));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshCredentialsEditorBase.this.updateOnAuthTypeChange();
                if (focusPassField) {
                    JTextField focus = SshCredentialsEditorBase.this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD ? SshCredentialsEditorBase.this.myPasswordField : SshCredentialsEditorBase.this.myPrivateKeyFileField.getTextField();
                    IdeFocusManager.findInstanceByComponent((Component)focus).requestFocus((Component)focus, false);
                }
            }
        });
        this.myAuthTypeCombo.setRenderer((ListCellRenderer<AuthType>)new ColoredListCellRenderer<AuthType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends AuthType> list2, AuthType value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                SshUIUtil.append((ColoredTextContainer)this, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ssh/ui/SshCredentialsEditorBase$4", "customizeCellRenderer"));
            }
        });
        this.myPasswordGroup = new PasswordGroup(AuthType.PASSWORD, this.myProvidedPasswordPanel, this.mySavedPasswordLabel, (JCheckBox)this.mySavePasswordCheckBox, (JLabel)this.myPasswordLabel, this.myPasswordField, this.myResetPasswordLabel, SshBundle.message("label.password.saved.permanently", new Object[0]), SshBundle.message("label.password.saved.until.ide.restart", new Object[0]), credentials -> credentials.isStorePassword() ? StringUtil.notNullize((String)credentials.getPassword()) : StringUtil.nullize((String)credentials.getPassword()), RemoteCredentials::isStorePassword, (credentials, password) -> credentials.setPassword(password), (credentials, save) -> credentials.setStorePassword(save.booleanValue()));
        this.myPassphraseGroup = new PasswordGroup(AuthType.KEY_PAIR, this.myProvidedPassphrasePanel, this.mySavedPassphraseLabel, this.mySavePassphraseCheckbox, (JLabel)this.myPassphraseLabel, this.myPassphraseField, this.myResetPassphraseLabel, SshBundle.message("label.passphrase.saved.permanently", new Object[0]), SshBundle.message("label.passphrase.saved.until.ide.restart", new Object[0]), credentials -> credentials.isStorePassphrase() ? StringUtil.notNullize((String)credentials.getPassphrase()) : StringUtil.nullize((String)credentials.getPassphrase()), RemoteCredentials::isStorePassphrase, (credentials, passphrase) -> credentials.setPassphrase(passphrase), (credentials, save) -> credentials.setStorePassphrase(save.booleanValue()));
        this.updateOnAuthTypeChange();
        this.myField2Component = new HashMap<String, JComponent>();
        this.myField2Component.put("HOST", (JComponent)this.myHostField);
        this.myField2Component.put("PORT", (JComponent)this.myPortField);
        this.myField2Component.put("USERNAME", (JComponent)this.myUsernameField);
        this.myField2Component.put("PRIVATE_KEY_FILE", (JComponent)this.myPrivateKeyFileField);
        this.myPortField.setText(Integer.toString(22));
        this.myTestButton.setVisible(showTestButton);
        this.myHostField.getEmptyText().setText(SshBundle.message("empty.text.localhost", new Object[0]));
        this.updateAlarm();
    }

    private void createUIComponents() {
        this.myConnectionConfigPatchForm = new SshConnectionConfigPatchForm((Disposable)this);
        this.myConnectionConfigPatchPanel = this.myConnectionConfigPatchForm.getPanel();
    }

    private void updateAlarm() {
        if (this.myUpdateAlarm != null) {
            this.myUpdateAlarm.cancelAndRequest();
        }
    }

    public void setContainer(RemoteSdkEditorContainer container) {
        this.myContainer = container;
    }

    protected void updateNeedsPassphrase() {
        String keyFileText = this.getKeyFileText();
        if (StringUtil.isNotEmpty((String)keyFileText)) {
            boolean needsPassphrase;
            try {
                needsPassphrase = (Boolean)SshCredentialsVerifier.runWithTimeout(500L, () -> Ssh.isPassphraseMayBeRequired(keyFileText, SshBackendLibrary.get()));
            }
            catch (TimeoutException ignored) {
                needsPassphrase = false;
            }
            if (needsPassphrase) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setText(null);
                    this.myPassphraseField.setEnabled(true);
                    this.mySavePassphraseCheckbox.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(false);
                this.mySavePassphraseCheckbox.setSelected(false);
                this.mySavePassphraseCheckbox.setEnabled(false);
            }
        }
    }

    private void updateOnAuthTypeChange() {
        Object authType = this.myAuthTypeCombo.getSelectedItem();
        this.myPasswordGroup.updateOnAuthTypeChanged(authType);
        this.myPassphraseGroup.updateOnAuthTypeChanged(authType);
        if (authType == AuthType.PASSWORD) {
            this.myParseConfigCheckBox.setEnabled(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            int width = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(width, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
        } else if (authType == AuthType.KEY_PAIR) {
            this.myParseConfigCheckBox.setEnabled(true);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
        } else {
            this.myParseConfigCheckBox.setEnabled(false);
            this.myParseConfigCheckBox.setSelected(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            this.myPrivateKeyFileField.setVisible(false);
        }
        if (this.myContainer != null) {
            this.myContainer.updateSize();
        }
        this.updateAlarm();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myHostField;
        if (jBTextField == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(0);
        }
        return jBTextField;
    }

    private void setAuthTypeCombo(@NotNull AuthType authType) {
        if (authType == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(1);
        }
        this.myAuthTypeCombo.setSelectedItem(authType);
        this.updateOnAuthTypeChange();
    }

    public void resetEditorFrom(@NotNull T credentials) {
        if (credentials == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(2);
        }
        this.resetEditor((RemoteCredentials)credentials);
    }

    public void resetEditor(RemoteCredentials credentials) {
        this.myHostField.setText(credentials.getHost());
        this.myPortField.setText(credentials.getLiteralPort());
        this.myUsernameField.setText(credentials.getUserName());
        this.setAuthTypeCombo(credentials.getAuthType());
        this.myPrivateKeyFileField.setText(credentials.getPrivateKeyFile());
        this.myPasswordGroup.resetPasswordData(credentials);
        this.myPassphraseGroup.resetPasswordData(credentials);
        this.myParseConfigCheckBox.setSelected(credentials.shouldUseOpenSshConfig());
        this.myConnectionConfigPatchForm.reset(credentials.getConnectionConfigPatch());
    }

    public void applyEditorTo(@NotNull T credentials) {
        if (credentials == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(3);
        }
        credentials.setHost(this.gerHostText());
        credentials.setLiteralPort(this.getPortText());
        credentials.setOpenSshConfigUsageForced(this.myParseConfigCheckBox.isSelected());
        String username = this.getUsernameText();
        if (username != null) {
            username = username.trim();
        }
        credentials.setUserName(username);
        Object authType = this.myAuthTypeCombo.getSelectedItem();
        this.myPasswordGroup.applyTo((MutableRemoteCredentials)credentials, authType);
        this.myPassphraseGroup.applyTo((MutableRemoteCredentials)credentials, authType);
        if (authType == AuthType.KEY_PAIR) {
            credentials.setAuthType(AuthType.KEY_PAIR);
            credentials.setPrivateKeyFile(this.getKeyFileText());
        } else if (authType == AuthType.OPEN_SSH) {
            credentials.setAuthType(AuthType.OPEN_SSH);
            credentials.setPrivateKeyFile(null);
        } else {
            credentials.setAuthType(AuthType.PASSWORD);
            credentials.setPrivateKeyFile(null);
        }
        SshConnectionConfigPatch configPatch = this.myConnectionConfigPatchForm.applyAndGet();
        credentials.setConnectionConfigPatch(configPatch);
    }

    public boolean isModified(@NotNull T credentials) {
        if (credentials == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(4);
        }
        if (!SshCredentialsEditorBase.equalsNullized(credentials.getHost(), this.gerHostText())) {
            return true;
        }
        if (!SshCredentialsEditorBase.equalsNullized(credentials.getLiteralPort(), this.getPortText())) {
            return true;
        }
        if (!SshCredentialsEditorBase.equalsNullized(credentials.getUserName(), this.getUsernameText())) {
            return true;
        }
        if (credentials.shouldUseOpenSshConfig() != this.myParseConfigCheckBox.isSelected()) {
            return true;
        }
        AuthType authType = credentials.getAuthType();
        if (authType != this.myAuthTypeCombo.getSelectedItem()) {
            return true;
        }
        if (this.myPasswordGroup.isModified(authType, (RemoteCredentials)credentials)) {
            return true;
        }
        if (this.myPassphraseGroup.isModified(authType, (RemoteCredentials)credentials)) {
            return true;
        }
        if (authType == AuthType.KEY_PAIR && !SshCredentialsEditorBase.equalsNullized(credentials.getPrivateKeyFile(), this.getKeyFileText())) {
            return true;
        }
        return this.myConnectionConfigPatchForm.isModified(credentials.getConnectionConfigPatch());
    }

    private static boolean equalsNullized(@Nullable String first, @Nullable String second) {
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)first), (CharSequence)StringUtil.nullize((String)second));
    }

    @NotNull
    public JPanel createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
    }

    @Nullable
    public ValidationInfo validateConnectionConfigPatch() {
        return this.myConnectionConfigPatchForm.getValidationInfo();
    }

    @Nullable
    public ValidationInfo createValidationInfo(@NotNull Pair<@Nls String, String> errorMessageAndField) {
        String field;
        if (errorMessageAndField == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(6);
        }
        JComponent component = (field = (String)errorMessageAndField.getSecond()) == null ? null : this.myField2Component.get(field);
        return new ValidationInfo((String)errorMessageAndField.getFirst(), component);
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myHostLabel.setAnchor(anchor);
    }

    @Nullable
    public String gerHostText() {
        return SshCredentialsEditorBase.getText(this.myHostField);
    }

    @Nullable
    public String getPortText() {
        return SshCredentialsEditorBase.getText(this.myPortField);
    }

    @Nullable
    public String getUsernameText() {
        return SshCredentialsEditorBase.getText(this.myUsernameField);
    }

    @Nullable
    public String getKeyFileText() {
        return SshCredentialsEditorBase.getText((JBTextField)this.myPrivateKeyFileField.getTextField());
    }

    @NotNull
    private static String getText(JBTextField field) {
        String text = field.getText();
        if (!StringUtil.isEmpty((String)text)) {
            String string = text.trim();
            if (string == null) {
                SshCredentialsEditorBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = field.getEmptyText().getText();
        if (string == null) {
            SshCredentialsEditorBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void updateAlarmCallback() {
        this.updateOpenSSHPortUser();
    }

    private void updateOpenSSHPortUser() {
        Object selectedItem = this.myAuthTypeCombo.getSelectedItem();
        if (!(selectedItem instanceof AuthType)) {
            this.myPortField.getEmptyText().clear();
            this.myUsernameField.getEmptyText().clear();
            return;
        }
        AuthType authType = (AuthType)selectedItem;
        switch (authType) {
            case KEY_PAIR: {
                @NlsSafe String path = FileUtil.normalize((String)(SystemProperties.getUserHome() + "//.ssh/id_rsa"));
                ((JBTextField)this.myPrivateKeyFileField.getTextField()).getEmptyText().setText(path);
            }
            case PASSWORD: {
                this.myPortField.getEmptyText().setText(String.valueOf(22));
                this.myUsernameField.getEmptyText().clear();
                break;
            }
            case OPEN_SSH: {
                OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
                if (openSSHConfig == null) {
                    return;
                }
                OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(this.myHostField.getText().trim());
                int port2 = hostConfig.getPort();
                this.myPortField.getEmptyText().setText(port2 == -1 ? "" : String.valueOf(port2));
                String user2 = hostConfig.getUser();
                this.myUsernameField.getEmptyText().setText(user2 == null ? "" : user2);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPasswordField jPasswordField2;
        JBLabel jBLabel2;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel3;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel2;
        JBLabel jBLabel4;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JBTextField jBTextField;
        JButton jButton;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHostLabel = jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.host.label"));
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.username.label"));
        jPanel3.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.authentication.type.label"));
        jPanel3.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAuthTypeCombo = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(2, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        this.myPrivateKeyFileLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.private.key.file.label"));
        jPanel3.add((Component)jBLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myUsernameField = jBTextField3 = new JBTextField();
        jPanel3.add((Component)jBTextField3, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myHostField = jBTextField2 = new JBTextField();
        jPanel3.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.test.connection.button"));
        jPanel3.add((Component)jButton, new GridConstraints(9, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.port.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myPortField = jBTextField = new JBTextField();
        jBTextField.setText("");
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myConnectionConfigPatchPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(10, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myParseConfigCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.parse.openssh.config.file"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(8, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myProvidedPasswordPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySavedPasswordLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("---");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 1));
        this.myResetPasswordLabel = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myProvidedPassphrasePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(7, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySavedPassphraseLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("----");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myResetPassphraseLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myPasswordLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.password.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel3.add((Component)jPasswordField2, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.mySavePasswordCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.save.password.combobox"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(3, 2, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myPassphraseLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.passphrase.label"));
        jPanel3.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPasswordField.setText("");
        jPanel3.add((Component)jPasswordField, new GridConstraints(6, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SshBundle", SshCredentialsEditorBase.class).getString("ssh.editor.save.passphrase.label"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(6, 2, 1, 2, 8, 0, 3, 0, null, null, null));
        jBLabel6.setLabelFor((Component)jBTextField2);
        jBLabel7.setLabelFor((Component)jBTextField3);
        jBLabel8.setLabelFor(jComboBox);
        jBLabel5.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel.setLabelFor((Component)jBTextField);
        jBLabel2.setLabelFor(jPasswordField2);
        jBLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/SshCredentialsEditorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageAndField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/SshCredentialsEditorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAuthTypeCombo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createValidationInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class PasswordGroup {
        private final boolean myShowSaveCheckboxes = !PasswordSafe.getInstance().isMemoryOnly();
        private final AuthType myAuthType;
        private final JPanel myProvidedPasswordPanel;
        private final JBLabel myProvidedPasswordLabel;
        private final JLabel myPasswordFieldLabel;
        private final JPasswordField myPasswordField;
        private final JCheckBox mySavePasswordCheckBox;
        private final @NlsContexts.Label String mySavedPasswordMessage;
        private final @NlsContexts.Label String myUnsavedPasswordMessage;
        private final Function<? super RemoteCredentials, String> myPasswordProvider;
        private final Function<? super RemoteCredentials, Boolean> mySavedProvider;
        private final BiConsumer<? super MutableRemoteCredentials, ? super String> myPasswordSetter;
        private final BiConsumer<? super MutableRemoteCredentials, ? super Boolean> mySavedSetter;
        private boolean myPasswordReset = false;
        private String myInitialPassword = null;
        private boolean myInitialSavePassword = false;

        private PasswordGroup(AuthType authType, JPanel providedPasswordPanel, JBLabel savedPasswordLabel, JCheckBox savePasswordCheckBox, JLabel passwordFieldLabel, JPasswordField passwordField, HyperlinkLabel resetPasswordLabel, @NlsContexts.Label String savedPasswordMessage, @NlsContexts.Label String unsavedPasswordMessage, Function<? super RemoteCredentials, String> passwordProvider, Function<? super RemoteCredentials, Boolean> isSavedProvider, BiConsumer<? super MutableRemoteCredentials, ? super String> passwordSetter, BiConsumer<? super MutableRemoteCredentials, ? super Boolean> isSavedSetter) {
            this.myAuthType = authType;
            this.myProvidedPasswordPanel = providedPasswordPanel;
            this.myProvidedPasswordLabel = savedPasswordLabel;
            this.mySavePasswordCheckBox = savePasswordCheckBox;
            this.myPasswordFieldLabel = passwordFieldLabel;
            this.myPasswordField = passwordField;
            this.mySavedPasswordMessage = savedPasswordMessage;
            this.myUnsavedPasswordMessage = unsavedPasswordMessage;
            this.myPasswordProvider = passwordProvider;
            this.mySavedProvider = isSavedProvider;
            this.myPasswordSetter = passwordSetter;
            this.mySavedSetter = isSavedSetter;
            resetPasswordLabel.setHyperlinkText(SshBundle.message("link.label.reset", new Object[0]));
            resetPasswordLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    myPasswordReset = true;
                    myProvidedPasswordPanel.setVisible(false);
                    myPasswordField.setText(null);
                    mySavePasswordCheckBox.setSelected(myInitialSavePassword);
                    this.setEmptyPasswordPanelVisible(true);
                }
            });
            this.mySavePasswordCheckBox.setVisible(this.myShowSaveCheckboxes);
        }

        private void setEmptyPasswordPanelVisible(boolean visible) {
            this.myPasswordFieldLabel.setVisible(visible);
            this.myPasswordField.setVisible(visible);
            this.mySavePasswordCheckBox.setVisible(visible);
        }

        private void updateOnAuthTypeChanged(Object authType) {
            if (authType == this.myAuthType) {
                boolean showEmptyPassword = this.myPasswordReset || !PasswordGroup.isInitiallyPasswordProvided(this.myInitialPassword, this.myInitialSavePassword);
                this.setEmptyPasswordPanelVisible(showEmptyPassword);
                this.myProvidedPasswordPanel.setVisible(!showEmptyPassword);
            } else {
                this.setEmptyPasswordPanelVisible(false);
                this.myProvidedPasswordPanel.setVisible(false);
                this.myPasswordField.setText(null);
                this.mySavePasswordCheckBox.setSelected(false);
            }
        }

        private void resetPasswordData(RemoteCredentials credentials) {
            this.myPasswordReset = false;
            if (credentials.getAuthType() != this.myAuthType) {
                this.myProvidedPasswordPanel.setVisible(false);
                this.setEmptyPasswordPanelVisible(false);
                return;
            }
            this.myInitialPassword = this.myPasswordProvider.apply((RemoteCredentials)credentials);
            this.myInitialSavePassword = this.mySavedProvider.apply((RemoteCredentials)credentials);
            if (PasswordGroup.isInitiallyPasswordProvided(this.myInitialPassword, this.myInitialSavePassword)) {
                this.setEmptyPasswordPanelVisible(false);
                this.myProvidedPasswordLabel.setText(this.myInitialSavePassword && this.myShowSaveCheckboxes ? this.mySavedPasswordMessage : this.myUnsavedPasswordMessage);
                this.myProvidedPasswordPanel.setVisible(true);
            } else {
                this.myProvidedPasswordPanel.setVisible(false);
                this.myPasswordField.setText(null);
                this.mySavePasswordCheckBox.setSelected(false);
                this.setEmptyPasswordPanelVisible(true);
            }
        }

        private static boolean isInitiallyPasswordProvided(String password, boolean savePassword) {
            return savePassword || !StringUtil.isEmpty((String)password);
        }

        private void applyTo(MutableRemoteCredentials credentials, Object authType) {
            if (authType != this.myAuthType) {
                this.myPasswordSetter.accept((MutableRemoteCredentials)credentials, null);
                this.mySavedSetter.accept((MutableRemoteCredentials)credentials, (Boolean)false);
                return;
            }
            this.myPasswordSetter.accept((MutableRemoteCredentials)credentials, this.getPasswordToApply());
            this.mySavedSetter.accept((MutableRemoteCredentials)credentials, (Boolean)this.getStorePasswordToApply());
        }

        private String getPasswordToApply() {
            if (!PasswordGroup.isInitiallyPasswordProvided(this.myInitialPassword, this.myInitialSavePassword) || this.myPasswordReset) {
                String rawPassword = new String(this.myPasswordField.getPassword());
                return this.mySavePasswordCheckBox.isSelected() ? rawPassword : StringUtil.nullize((String)rawPassword);
            }
            return this.myInitialPassword;
        }

        private boolean getStorePasswordToApply() {
            if (!PasswordGroup.isInitiallyPasswordProvided(this.myInitialPassword, this.myInitialSavePassword) || this.myPasswordReset) {
                return this.myShowSaveCheckboxes && this.mySavePasswordCheckBox.isSelected();
            }
            return this.myShowSaveCheckboxes && this.myInitialSavePassword;
        }

        public boolean isModified(AuthType authType, RemoteCredentials credentials) {
            boolean isSavePassword;
            if (authType != this.myAuthType) {
                return false;
            }
            String password = this.myPasswordProvider.apply((RemoteCredentials)credentials);
            if (!PasswordGroup.isInitiallyPasswordProvided(password, isSavePassword = this.mySavedProvider.apply((RemoteCredentials)credentials).booleanValue())) {
                if (this.myShowSaveCheckboxes && this.getStorePasswordToApply()) {
                    return true;
                }
                String passwordToApply = this.getPasswordToApply();
                if (passwordToApply != null && !passwordToApply.isEmpty()) {
                    return true;
                }
            } else if (this.myPasswordReset) {
                return true;
            }
            return false;
        }
    }
}

