/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.channels;

import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.impl.channels.FailSafeRemoteFileObjectKt;
import com.intellij.ssh.impl.channels.FileChannelRegistry;
import java.io.IOException;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ssh/impl/channels/StreamGuard;", "", "fileChannelRegistry", "Lcom/intellij/ssh/impl/channels/FileChannelRegistry;", "path", "", "initialUnderlyingFile", "Lcom/intellij/ssh/RemoteFileObject;", "(Lcom/intellij/ssh/impl/channels/FileChannelRegistry;Ljava/lang/String;Lcom/intellij/ssh/RemoteFileObject;)V", "initialFileRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "lock", "Ljava/lang/Object;", "rememberedError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "call", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nFailSafeRemoteFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FailSafeRemoteFileObject.kt\ncom/intellij/ssh/impl/channels/StreamGuard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
final class StreamGuard {
    @NotNull
    private final FileChannelRegistry fileChannelRegistry;
    @NotNull
    private final String path;
    @NotNull
    private final WeakReference<RemoteFileObject> initialFileRef;
    @NotNull
    private final Object lock;
    @Nullable
    private Exception rememberedError;

    public StreamGuard(@NotNull FileChannelRegistry fileChannelRegistry, @NotNull String path, @NotNull RemoteFileObject initialUnderlyingFile) {
        Intrinsics.checkNotNullParameter((Object)fileChannelRegistry, (String)"fileChannelRegistry");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)initialUnderlyingFile, (String)"initialUnderlyingFile");
        this.fileChannelRegistry = fileChannelRegistry;
        this.path = path;
        this.initialFileRef = new WeakReference<RemoteFileObject>(initialUnderlyingFile);
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T call(@NotNull Function0<? extends T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Exception exception = this.rememberedError;
            if (exception != null) {
                Exception it = exception;
                boolean bl2 = false;
                throw it;
            }
            RemoteFileObject it = (RemoteFileObject)this.initialFileRef.get();
            boolean bl3 = false;
            if (it == null || !this.fileChannelRegistry.checkFileObjectIsValid(it)) {
                throw new IOException("Stream refers to disposed file object, path=" + this.path);
            }
            try {
                Object object2 = handler.invoke();
                return (T)object2;
            }
            catch (Exception e) {
                if (!FailSafeRemoteFileObjectKt.access$isRelevant(e)) throw e;
                this.rememberedError = e;
                this.fileChannelRegistry.onErrorOccurred();
                throw e;
            }
        }
    }
}

