/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;
import org.jetbrains.qodana.ui.problemsView.tree.model.NavigationKt;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.PresentationKt;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNodeBase;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeProblemNodeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeProblemNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;", "parent", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "primaryData", "(Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;)V", "computeModelTreeNode", "doUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "modelTreeNode", "getChildren", "", "getExcludeActionsDescriptors", "", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode$ExcludeActionDescriptor;", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaUiTreeProblemNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaUiTreeProblemNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeProblemNode\n+ 2 QodanaUiTreeNodeBase.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase\n*L\n1#1,93:1\n53#2:94\n*S KotlinDebug\n*F\n+ 1 QodanaUiTreeProblemNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeProblemNode\n*L\n25#1:94\n*E\n"})
public final class QodanaUiTreeProblemNode
extends QodanaUiTreeNodeBase<QodanaTreeProblemNode, QodanaTreeProblemNode.PrimaryData> {
    public QodanaUiTreeProblemNode(@NotNull QodanaUiTreeNode<?, ?> parent, @NotNull QodanaTreeProblemNode.PrimaryData primaryData) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)primaryData, (String)"primaryData");
        super(parent, (QodanaTreeNode.PrimaryData)primaryData);
    }

    @Override
    @Nullable
    public QodanaTreeProblemNode computeModelTreeNode() {
        QodanaUiTreeNodeBase this_$iv = this;
        boolean $i$f$computeModelTreeNodeThroughParent = false;
        return (QodanaTreeProblemNode)QodanaUiTreeNodeBase.access$computeModelTreeNodeThroughParentViaClazz(this_$iv, QodanaTreeProblemNode.class);
    }

    @Override
    @NotNull
    public List<QodanaUiTreeNode.ExcludeActionDescriptor> getExcludeActionsDescriptors() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<QodanaUiTreeNodeBase<?, ?>> getChildren() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        QodanaTreeProblemNode qodanaTreeProblemNode = (QodanaTreeProblemNode)this.getModelTreeNode();
        return qodanaTreeProblemNode != null ? qodanaTreeProblemNode.getVirtualFile() : null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        QodanaTreeProblemNode qodanaTreeProblemNode = (QodanaTreeProblemNode)this.getModelTreeNode();
        if (qodanaTreeProblemNode == null) {
            return null;
        }
        QodanaTreeProblemNode modelTreeNode = qodanaTreeProblemNode;
        Navigatable nodeNavigatable = NavigationKt.navigatable(modelTreeNode, project2);
        return new Navigatable(nodeNavigatable, project2, modelTreeNode){
            private final /* synthetic */ Navigatable $$delegate_0;
            final /* synthetic */ Navigatable $nodeNavigatable;
            final /* synthetic */ Project $project;
            final /* synthetic */ QodanaTreeProblemNode $modelTreeNode;
            {
                this.$nodeNavigatable = $nodeNavigatable;
                this.$project = $project;
                this.$modelTreeNode = $modelTreeNode;
                this.$$delegate_0 = $nodeNavigatable;
            }

            public void navigate(boolean requestFocus) {
                QodanaPluginStatsCounterCollector.PROBLEM_NAVIGATED.log(this.$project, (Object)((Object)QodanaPluginStatsCounterCollectorKt.toSelectedNodeType(this.$modelTreeNode)), (Object)this.$modelTreeNode.getProblemsCount());
                this.$nodeNavigatable.navigate(requestFocus);
            }

            public boolean canNavigateToSource() {
                return this.$nodeNavigatable.canNavigateToSource();
            }

            public boolean canNavigate() {
                return this.$nodeNavigatable.canNavigate();
            }
        };
    }

    @Override
    public void doUpdate(@NotNull Project project, @NotNull PresentationData presentation, @NotNull QodanaTreeProblemNode modelTreeNode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)modelTreeNode, (String)"modelTreeNode");
        SarifProblem sarifProblem = ((QodanaTreeProblemNode.PrimaryData)this.getPrimaryData()).getSarifProblem();
        String message = SarifProblemKt.buildDescription(sarifProblem, false, false);
        SarifProblemProperties sarifProblemProperties = modelTreeNode.getSarifProblemProperties();
        presentation.setIcon(sarifProblem.getQodanaSeverity().getIcon());
        if (modelTreeNode.getExcluded()) {
            presentation.addText(message, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            String string = QodanaBundle.message("qodana.TreeNode.excluded", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_BOLD_ATTRIBUTES");
            PresentationKt.appendText(presentation, string, simpleTextAttributes);
            return;
        }
        presentation.addText(message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (sarifProblem.isInBaseline()) {
            String string = QodanaBundle.message("qodana.problem.baseline", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SYNTHETIC_ATTRIBUTES");
            PresentationKt.appendText(presentation, string, simpleTextAttributes);
        }
        if (sarifProblemProperties.isMissing()) {
            String string = QodanaBundle.message("qodana.problem.not.present", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"ERROR_ATTRIBUTES");
            PresentationKt.appendText(presentation, string, simpleTextAttributes);
            return;
        }
        if (sarifProblemProperties.isFixed()) {
            String string = QodanaBundle.message("qodana.problem.fixed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PresentationKt.appendText(presentation, string, new SimpleTextAttributes(0, (Color)QodanaUiTreeProblemNodeKt.access$getFIXED_PROBLEM_COLOR$p()));
            return;
        }
        int line = sarifProblemProperties.getLine();
        if (line >= 0) {
            presentation.addText(" :" + (line + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @NotNull
    public String getName() {
        return ((QodanaTreeProblemNode.PrimaryData)this.getPrimaryData()).toString();
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.ALWAYS;
    }
}

