/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpClient;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.publisher.ConfigBuilder;
import org.jetbrains.qodana.publisher.PublisherException;
import org.jetbrains.qodana.publisher.schemas.ReportType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 =2\u00020\u0001:\u0001=B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0014H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\tH\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\u0011\u00103\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\fH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u009d\u0001\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017\u00a8\u0006>"}, d2={"Lorg/jetbrains/qodana/publisher/Config;", "", "token", "", "endpoint", "reportType", "Lorg/jetbrains/qodana/publisher/schemas/ReportType;", "analysisId", "reportPath", "Ljava/nio/file/Path;", "sourcesPath", "tools", "", "branch", "commit", "projectUrl", "client", "Ljava/net/http/HttpClient;", "version", "uploadTimeout", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/qodana/publisher/schemas/ReportType;Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/net/http/HttpClient;Ljava/lang/String;Ljava/time/Duration;)V", "getAnalysisId", "()Ljava/lang/String;", "getBranch", "getClient", "()Ljava/net/http/HttpClient;", "getCommit", "getEndpoint", "getProjectUrl", "getReportPath", "()Ljava/nio/file/Path;", "getReportType", "()Lorg/jetbrains/qodana/publisher/schemas/ReportType;", "getSourcesPath", "getToken", "getTools", "()Ljava/util/List;", "getUploadTimeout", "()Ljava/time/Duration;", "getVersion", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "publisher"})
public final class Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    @NotNull
    private final String endpoint;
    @NotNull
    private final ReportType reportType;
    @Nullable
    private final String analysisId;
    @NotNull
    private final Path reportPath;
    @NotNull
    private final Path sourcesPath;
    @Nullable
    private final List<String> tools;
    @Nullable
    private final String branch;
    @Nullable
    private final String commit;
    @Nullable
    private final String projectUrl;
    @NotNull
    private final HttpClient client;
    @Nullable
    private final String version;
    @NotNull
    private final Duration uploadTimeout;

    public Config(@NotNull String token, @NotNull String endpoint, @NotNull ReportType reportType, @Nullable String analysisId, @NotNull Path reportPath2, @NotNull Path sourcesPath, @Nullable List<String> tools, @Nullable String branch, @Nullable String commit, @Nullable String projectUrl, @NotNull HttpClient client, @Nullable String version, @NotNull Duration uploadTimeout) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)reportPath2, (String)"reportPath");
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)uploadTimeout, (String)"uploadTimeout");
        this.token = token;
        this.endpoint = endpoint;
        this.reportType = reportType;
        this.analysisId = analysisId;
        this.reportPath = reportPath2;
        this.sourcesPath = sourcesPath;
        this.tools = tools;
        this.branch = branch;
        this.commit = commit;
        this.projectUrl = projectUrl;
        this.client = client;
        this.version = version;
        this.uploadTimeout = uploadTimeout;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final ReportType getReportType() {
        return this.reportType;
    }

    @Nullable
    public final String getAnalysisId() {
        return this.analysisId;
    }

    @NotNull
    public final Path getReportPath() {
        return this.reportPath;
    }

    @NotNull
    public final Path getSourcesPath() {
        return this.sourcesPath;
    }

    @Nullable
    public final List<String> getTools() {
        return this.tools;
    }

    @Nullable
    public final String getBranch() {
        return this.branch;
    }

    @Nullable
    public final String getCommit() {
        return this.commit;
    }

    @Nullable
    public final String getProjectUrl() {
        return this.projectUrl;
    }

    @NotNull
    public final HttpClient getClient() {
        return this.client;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final Duration getUploadTimeout() {
        return this.uploadTimeout;
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    @NotNull
    public final String component2() {
        return this.endpoint;
    }

    @NotNull
    public final ReportType component3() {
        return this.reportType;
    }

    @Nullable
    public final String component4() {
        return this.analysisId;
    }

    @NotNull
    public final Path component5() {
        return this.reportPath;
    }

    @NotNull
    public final Path component6() {
        return this.sourcesPath;
    }

    @Nullable
    public final List<String> component7() {
        return this.tools;
    }

    @Nullable
    public final String component8() {
        return this.branch;
    }

    @Nullable
    public final String component9() {
        return this.commit;
    }

    @Nullable
    public final String component10() {
        return this.projectUrl;
    }

    @NotNull
    public final HttpClient component11() {
        return this.client;
    }

    @Nullable
    public final String component12() {
        return this.version;
    }

    @NotNull
    public final Duration component13() {
        return this.uploadTimeout;
    }

    @NotNull
    public final Config copy(@NotNull String token, @NotNull String endpoint, @NotNull ReportType reportType, @Nullable String analysisId, @NotNull Path reportPath2, @NotNull Path sourcesPath, @Nullable List<String> tools, @Nullable String branch, @Nullable String commit, @Nullable String projectUrl, @NotNull HttpClient client, @Nullable String version, @NotNull Duration uploadTimeout) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)reportPath2, (String)"reportPath");
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)uploadTimeout, (String)"uploadTimeout");
        return new Config(token, endpoint, reportType, analysisId, reportPath2, sourcesPath, tools, branch, commit, projectUrl, client, version, uploadTimeout);
    }

    public static /* synthetic */ Config copy$default(Config config, String string, String string2, ReportType reportType, String string3, Path path, Path path2, List list2, String string4, String string5, String string6, HttpClient httpClient, String string7, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            string = config.token;
        }
        if ((n & 2) != 0) {
            string2 = config.endpoint;
        }
        if ((n & 4) != 0) {
            reportType = config.reportType;
        }
        if ((n & 8) != 0) {
            string3 = config.analysisId;
        }
        if ((n & 0x10) != 0) {
            path = config.reportPath;
        }
        if ((n & 0x20) != 0) {
            path2 = config.sourcesPath;
        }
        if ((n & 0x40) != 0) {
            list2 = config.tools;
        }
        if ((n & 0x80) != 0) {
            string4 = config.branch;
        }
        if ((n & 0x100) != 0) {
            string5 = config.commit;
        }
        if ((n & 0x200) != 0) {
            string6 = config.projectUrl;
        }
        if ((n & 0x400) != 0) {
            httpClient = config.client;
        }
        if ((n & 0x800) != 0) {
            string7 = config.version;
        }
        if ((n & 0x1000) != 0) {
            duration = config.uploadTimeout;
        }
        return config.copy(string, string2, reportType, string3, path, path2, list2, string4, string5, string6, httpClient, string7, duration);
    }

    @NotNull
    public String toString() {
        return "Config(token=" + this.token + ", endpoint=" + this.endpoint + ", reportType=" + this.reportType + ", analysisId=" + this.analysisId + ", reportPath=" + this.reportPath + ", sourcesPath=" + this.sourcesPath + ", tools=" + this.tools + ", branch=" + this.branch + ", commit=" + this.commit + ", projectUrl=" + this.projectUrl + ", client=" + this.client + ", version=" + this.version + ", uploadTimeout=" + this.uploadTimeout + ")";
    }

    public int hashCode() {
        int result2 = this.token.hashCode();
        result2 = result2 * 31 + this.endpoint.hashCode();
        result2 = result2 * 31 + this.reportType.hashCode();
        result2 = result2 * 31 + (this.analysisId == null ? 0 : this.analysisId.hashCode());
        result2 = result2 * 31 + ((Object)this.reportPath).hashCode();
        result2 = result2 * 31 + ((Object)this.sourcesPath).hashCode();
        result2 = result2 * 31 + (this.tools == null ? 0 : ((Object)this.tools).hashCode());
        result2 = result2 * 31 + (this.branch == null ? 0 : this.branch.hashCode());
        result2 = result2 * 31 + (this.commit == null ? 0 : this.commit.hashCode());
        result2 = result2 * 31 + (this.projectUrl == null ? 0 : this.projectUrl.hashCode());
        result2 = result2 * 31 + this.client.hashCode();
        result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
        result2 = result2 * 31 + this.uploadTimeout.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Config)) {
            return false;
        }
        Config config = (Config)other;
        if (!Intrinsics.areEqual((Object)this.token, (Object)config.token)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endpoint, (Object)config.endpoint)) {
            return false;
        }
        if (this.reportType != config.reportType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.analysisId, (Object)config.analysisId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.reportPath, (Object)config.reportPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourcesPath, (Object)config.sourcesPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tools, config.tools)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.branch, (Object)config.branch)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commit, (Object)config.commit)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectUrl, (Object)config.projectUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.client, (Object)config.client)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)config.version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uploadTimeout, (Object)config.uploadTimeout);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/qodana/publisher/Config$Companion;", "", "()V", "invoke", "Lorg/jetbrains/qodana/publisher/Config;", "configuration", "Lkotlin/Function1;", "Lorg/jetbrains/qodana/publisher/ConfigBuilder;", "", "Lkotlin/ExtensionFunctionType;", "publisher"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @NotNull
        public final Config invoke(@NotNull Function1<? super ConfigBuilder, Unit> configuration) {
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            var3_2 = new ConfigBuilder();
            configuration.invoke((Object)var3_2);
            builder = var3_2;
            v0 = builder.getToken();
            if (v0 == null) {
                throw new PublisherException("Token must be specified", null, 2, null);
            }
            token = v0;
            v1 = builder.getEndpoint();
            if (v1 == null) {
                v1 = endpoint = "https://api.qodana.cloud";
            }
            if ((v2 = builder.getReportPath()) == null) {
                v2 = reportPath = Paths.get("/data/report", new String[0]);
            }
            if ((v3 = builder.getSourcesPath()) == null) {
                v3 = sourcesPath = Paths.get("/data/source", new String[0]);
            }
            if ((v4 = builder.getReportType()) == null) {
                Intrinsics.checkNotNullExpressionValue((Object)reportPath, (String)"reportPath");
                v4 = reportType = ReportType.Companion.inferFrom(reportPath);
            }
            if ((v5 = builder.getClient()) == null) {
                v5 = client = HttpClient.newHttpClient();
            }
            if ((var10_9 = this.getClass().getClassLoader().getResourceAsStream("version")) == null) ** GOTO lbl-1000
            var11_10 = var10_9;
            var12_11 = Charsets.UTF_8;
            var13_12 = new InputStreamReader((InputStream)var11_10, (Charset)var12_11);
            var14_13 = 8192;
            var12_11 = var13_12 instanceof BufferedReader != false ? (BufferedReader)var13_12 : new BufferedReader((Reader)var13_12, var14_13);
            var13_12 = null;
            try {
                it = (BufferedReader)var12_11;
                $i$a$-use-Config$Companion$invoke$version$1 = false;
                var14_14 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable var14_15) {
                var13_12 = var14_15;
                throw var14_15;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var12_11, (Throwable)var13_12);
            }
            var11_10 = var14_14;
            if (var11_10 != null) {
                v6 = StringsKt.trim((CharSequence)((CharSequence)var11_10)).toString();
            } else lbl-1000:
            // 2 sources

            {
                v6 = version = null;
            }
            if ((v7 = builder.getUploadTimeout()) == null) {
                v7 = Duration.ofSeconds(Integer.getInteger("qodana.publisher.upload.timeout.seconds", 300).intValue());
            }
            uploadTimeout = v7;
            v8 = builder.getAnalysisId();
            Intrinsics.checkNotNullExpressionValue((Object)reportPath, (String)"reportPath");
            Intrinsics.checkNotNullExpressionValue((Object)sourcesPath, (String)"sourcesPath");
            v9 = builder.getTools();
            v10 = builder.getBranch();
            v11 = builder.getCommit();
            v12 = builder.getProjectUrl();
            Intrinsics.checkNotNullExpressionValue((Object)client, (String)"client");
            Intrinsics.checkNotNullExpressionValue((Object)uploadTimeout, (String)"uploadTimeout");
            return new Config(token, endpoint, reportType, v8, reportPath, sourcesPath, v9, v10, v11, v12, client, version, uploadTimeout);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

