/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.api;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.inspectionKts.api.LocalInspection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/inspectionKts/api/LocalInspectionImpl;", "Lorg/jetbrains/qodana/inspectionKts/api/LocalInspection;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "currentFile", "Lcom/intellij/psi/PsiFile;", "getCurrentFile", "()Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "registerProblem", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "message", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "intellij.qodana"})
public final class LocalInspectionImpl
implements LocalInspection {
    @NotNull
    private final ProblemsHolder problemsHolder;

    public LocalInspectionImpl(@NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        this.problemsHolder = problemsHolder;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.problemsHolder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Override
    @NotNull
    public PsiFile getCurrentFile() {
        PsiFile psiFile2 = this.problemsHolder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        return psiFile2;
    }

    @Override
    public void registerProblem(@Nullable PsiElement psiElement, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)this.getCurrentFile();
        }
        this.problemsHolder.registerProblem(psiElement2, message, new LocalQuickFix[0]);
    }

    @Override
    public void registerProblem(@Nullable PsiElement psiElement, @NotNull String message, LocalQuickFix ... fixes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)this.getCurrentFile();
        }
        this.problemsHolder.registerProblem(psiElement2, message, Arrays.copyOf(fixes, fixes.length));
    }
}

