/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html.ui;

import com.vladsch.flexmark.util.html.ui.BackgroundColor;
import com.vladsch.flexmark.util.html.ui.HtmlBuilder;
import com.vladsch.flexmark.util.misc.Utils;
import java.awt.Color;
import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;

public class HtmlHelpers {
    public static String toHtmlError(String err, boolean withContext) {
        String group;
        Matcher matcher;
        if (err == null) {
            return null;
        }
        if (withContext && (matcher = Pattern.compile("(?:^|\n)(.*\n)(\\s*)\\^(\n?)$").matcher((CharSequence)err)).find() && (group = matcher.group(2)) != null && !group.isEmpty()) {
            int prevLineStart = matcher.group(1) != null ? matcher.start(1) : matcher.start(2);
            String lastLine = Utils.repeat("&nbsp;", group.length());
            err = ((String)err).substring(0, prevLineStart) + "<span style=\"font-family:monospaced\">" + ((String)err).substring(prevLineStart, matcher.start(2)).replace(" ", "&nbsp;") + lastLine + "^</span>" + group;
        }
        return ((String)err).replace("\n", "<br>");
    }

    public static void setRegExError(String error, JTextPane jTextPane, Font textFont, BackgroundColor validTextFieldBackground, BackgroundColor warningTextFieldBackground) {
        HtmlBuilder html = new HtmlBuilder();
        ((HtmlBuilder)html.tag("html")).style("margin:2px;vertical-align:middle;").attr(validTextFieldBackground, textFont).tag("body");
        html.attr(warningTextFieldBackground).tag("div");
        html.append(HtmlHelpers.toHtmlError(error, true));
        html.closeTag("div");
        html.closeTag("body");
        html.closeTag("html");
        jTextPane.setVisible(true);
        jTextPane.setText(html.toFinalizedString());
        jTextPane.revalidate();
        jTextPane.getParent().revalidate();
        jTextPane.getParent().getParent().revalidate();
    }

    public static String withContext(String text2, String context, int pos, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(text2).append('\n');
        sb.append(prefix).append(context).append(suffix).append('\n');
        for (int i = 1; i < prefix.length(); ++i) {
            sb.append(' ');
        }
        sb.append('^').append('\n');
        return sb.toString();
    }

    public static String toRgbString(Color color) {
        return color == null ? "rgb(0,0,0)" : "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static String toHtmlString(Color color) {
        return color == null ? "#000000" : String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color mixedColor(Color originalColor, Color overlayColor) {
        float[] hsbColor = Color.RGBtoHSB(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), new float[3]);
        float[] hsbError = Color.RGBtoHSB(overlayColor.getRed(), overlayColor.getGreen(), overlayColor.getBlue(), new float[3]);
        float[] hsbMixed = new float[]{hsbError[0], Utils.rangeLimit(hsbColor[1], Utils.min(Utils.max(hsbError[1], 0.3f), 0.5f), 1.0f), Utils.rangeLimit(hsbColor[2], Utils.min(Utils.max(hsbError[2], 0.3f), 0.5f), 1.0f)};
        return Color.getHSBColor(hsbMixed[0], hsbMixed[1], hsbMixed[2]);
    }
}

