/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.xwiki.macros.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.xwiki.macros.Macro;
import com.vladsch.flexmark.ext.xwiki.macros.MacroAttribute;
import com.vladsch.flexmark.ext.xwiki.macros.MacroBlock;
import com.vladsch.flexmark.ext.xwiki.macros.MacroClose;
import com.vladsch.flexmark.ext.xwiki.macros.internal.MacroParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroBlockParser
extends AbstractBlockParser {
    private final MacroBlock block = new MacroBlock();
    private BlockContent content = new BlockContent();
    private final MacroParsing parsing;
    private final BasedSequence macroName;
    private final boolean oneLine;
    private boolean hadClose;

    MacroBlockParser(DataHolder options, MacroParsing parsing, BasedSequence macroName, boolean oneLine) {
        this.parsing = parsing;
        this.macroName = macroName;
        this.oneLine = oneLine;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (this.hadClose) {
            return BlockContinue.none();
        }
        BasedSequence line = state.getLine();
        Matcher closeMatcher = this.parsing.MACRO_CLOSE.matcher(line);
        if (closeMatcher.find() && this.macroName.equals(closeMatcher.group(1))) {
            BlockParser parser2;
            List<BlockParser> parsers = state.getActiveBlockParsers();
            boolean isChildClose = false;
            int i = parsers.size();
            while (i-- > 0 && (parser2 = parsers.get(i)) != this) {
                if (!(parser2 instanceof MacroBlockParser) || ((MacroBlockParser)parser2).hadClose || !((MacroBlockParser)parser2).macroName.equals(this.macroName)) continue;
                isChildClose = true;
            }
            if (!isChildClose) {
                this.hadClose = true;
                MacroClose macroClose = new MacroClose(line.subSequence(closeMatcher.start(), closeMatcher.start() + 3), line.subSequence(closeMatcher.start(1), closeMatcher.end(1)), line.subSequence(closeMatcher.end() - 2, closeMatcher.end()));
                macroClose.setCharsFromContent();
                this.block.appendChild(macroClose);
                return BlockContinue.atIndex(state.getLineEndIndex());
            }
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public void closeBlock(ParserState state) {
        if (this.oneLine) {
            ArrayList<BasedSequence> lines = new ArrayList<BasedSequence>();
            Macro macro = (Macro)this.block.getFirstChild();
            Node node = this.block.getLastChild();
            BasedSequence contentLine = node instanceof MacroClose ? macro.baseSubSequence(macro.getEndOffset(), node.getStartOffset()) : macro.baseSubSequence(macro.getEndOffset(), macro.getEndOffset());
            lines.add(contentLine);
            this.block.setContent(lines);
        } else if (this.hadClose) {
            List<BasedSequence> lines = this.content.getLines();
            this.block.setContent(lines);
        } else {
            List<BasedSequence> lines = this.content.getLines();
            this.block.setContent(lines.subList(0, lines.size()));
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        Node node = this.block.getLastChild();
        if (node instanceof MacroClose) {
            node.unlink();
        }
        inlineParser.parse(this.block.getContentChars(), this.block);
        if (node instanceof MacroClose) {
            this.block.appendChild(node);
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final MacroParsing parsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.parsing = new MacroParsing(new Parsing(options));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence tryLine;
            Matcher matcher;
            BasedSequence line = state.getLine();
            int currentIndent = state.getIndent();
            if (currentIndent != 0 || matchedBlockParser.getBlockParser().getBlock() instanceof Paragraph || !(matcher = this.parsing.MACRO_OPEN.matcher(tryLine = (BasedSequence)line.subSequence(state.getIndex()))).find()) return BlockStart.none();
            BasedSequence macroName = line.subSequence(matcher.start(1), matcher.end(1));
            BasedSequence macroOpen = tryLine.subSequence(0, matcher.end());
            BasedSequence afterOpen = (BasedSequence)tryLine.subSequence(matcher.end());
            boolean oneLine = false;
            boolean isClosedTag = false;
            MacroClose macroClose = null;
            if (macroOpen.endsWith("/}}")) {
                if (!afterOpen.isBlank()) return BlockStart.none();
                oneLine = true;
                isClosedTag = true;
            } else if (!afterOpen.isBlank()) {
                Matcher closeMatcher = this.parsing.MACRO_CLOSE_END.matcher(afterOpen);
                if (closeMatcher.find() && macroName.equals(closeMatcher.group(1)) && (closeMatcher.groupCount() < 2 || closeMatcher.start(2) == -1 || (closeMatcher.group(2).length() & 1) == 1)) {
                    oneLine = true;
                    macroClose = new MacroClose(afterOpen.subSequence(closeMatcher.start(), closeMatcher.start() + 3), afterOpen.subSequence(closeMatcher.start(1), closeMatcher.end(1)), afterOpen.subSequence(closeMatcher.end() - 2, closeMatcher.end()));
                    macroClose.setCharsFromContent();
                }
                if (!oneLine) {
                    return BlockStart.none();
                }
            }
            Macro macro = new Macro(macroOpen.subSequence(0, 2), macroName, (BasedSequence)macroOpen.endSequence(isClosedTag ? 3 : 2));
            macro.setCharsFromContent();
            BasedSequence attributeText = (BasedSequence)macroOpen.baseSubSequence(macroName.getEndOffset(), macro.getClosingMarker().getStartOffset()).trim();
            if (!attributeText.isEmpty()) {
                macro.setAttributeText(attributeText);
                Matcher attributeMatcher = this.parsing.MACRO_ATTRIBUTE.matcher(attributeText);
                while (attributeMatcher.find()) {
                    BasedSequence attributeClose;
                    BasedSequence attributeName = attributeText.subSequence(attributeMatcher.start(1), attributeMatcher.end(1));
                    BasedSequence attributeSeparator = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : (BasedSequence)attributeText.subSequence(attributeMatcher.end(1), attributeMatcher.start(2)).trim();
                    BasedSequence attributeValue = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : attributeText.subSequence(attributeMatcher.start(2), attributeMatcher.end(2));
                    boolean isQuoted = attributeValue.length() >= 2 && (attributeValue.charAt(0) == '\"' && attributeValue.endCharAt(1) == '\"' || attributeValue.charAt(0) == '\'' && attributeValue.endCharAt(1) == '\'');
                    BasedSequence attributeOpen = !isQuoted ? BasedSequence.NULL : attributeValue.subSequence(0, 1);
                    BasedSequence basedSequence = attributeClose = !isQuoted ? BasedSequence.NULL : (BasedSequence)attributeValue.endSequence(1, 0);
                    if (isQuoted) {
                        attributeValue = (BasedSequence)attributeValue.midSequence(1, -1);
                    }
                    MacroAttribute attribute = new MacroAttribute(attributeName, attributeSeparator, attributeOpen, attributeValue, attributeClose);
                    macro.appendChild(attribute);
                }
            }
            MacroBlockParser parser2 = new MacroBlockParser(state.getProperties(), this.parsing, macroName, oneLine);
            if (oneLine) {
                parser2.hadClose = true;
            }
            parser2.block.appendChild(macro);
            if (macroClose == null) return BlockStart.of(parser2).atIndex(state.getLineEndIndex());
            parser2.block.appendChild(macroClose);
            return BlockStart.of(parser2).atIndex(state.getLineEndIndex());
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

