/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util.headers;

import com.intellij.psi.PsiElement;
import dk.brics.automaton.Automaton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/language/util/headers/EditorConfigHeaderSearcherUtil;", "", "()V", "isActualParent", "", "parent", "Lcom/intellij/psi/PsiElement;", "child", "isPartialOverride", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "isStrictOverride", "intellij.editorconfig"})
public final class EditorConfigHeaderSearcherUtil {
    @NotNull
    public static final EditorConfigHeaderSearcherUtil INSTANCE = new EditorConfigHeaderSearcherUtil();

    private EditorConfigHeaderSearcherUtil() {
    }

    private final boolean isActualParent(PsiElement parent, PsiElement child) {
        return !Intrinsics.areEqual((Object)parent.getContainingFile(), (Object)child.getContainingFile()) || parent.getTextOffset() < child.getTextOffset();
    }

    public final boolean isPartialOverride(@NotNull EditorConfigHeader parent, @NotNull EditorConfigHeader child) {
        Automaton parentAutomaton;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!this.isActualParent(parent, child)) {
            return false;
        }
        Automaton childAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(child);
        Automaton intersection = childAutomaton.intersection(parentAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(parent));
        return !intersection.isEmpty();
    }

    public final boolean isStrictOverride(@NotNull EditorConfigHeader parent, @NotNull EditorConfigHeader child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!this.isActualParent(parent, child)) {
            return false;
        }
        return EditorConfigGlobUtilsKt.isSubcaseOf(child, parent);
    }
}

