/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.filetype.EditorConfigFileConstants;
import org.editorconfig.language.filetype.EditorConfigFileType;
import org.editorconfig.language.psi.EditorConfigCharClassPattern;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigQualifiedKeyPart;
import org.editorconfig.language.psi.EditorConfigQualifiedOptionKey;
import org.editorconfig.language.psi.EditorConfigRootDeclaration;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigElementFactoryImpl;", "Lorg/editorconfig/language/services/EditorConfigElementFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAnyValue", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "Lorg/jetbrains/annotations/Nullable;", "source", "", "createCharClassPattern", "Lorg/editorconfig/language/psi/EditorConfigCharClassPattern;", "createDummyFile", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "content", "createHeader", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "Lorg/jetbrains/annotations/NotNull;", "createKey", "createKeyPart", "Lorg/editorconfig/language/psi/EditorConfigQualifiedKeyPart;", "createOption", "Lorg/editorconfig/language/psi/EditorConfigOption;", "createPattern", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "createRootDeclaration", "Lorg/editorconfig/language/psi/EditorConfigRootDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "createSection", "Lorg/editorconfig/language/psi/EditorConfigSection;", "createValueIdentifier", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "intellij.editorconfig"})
public final class EditorConfigElementFactoryImpl
implements EditorConfigElementFactory {
    @NotNull
    private final Project project;

    public EditorConfigElementFactoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final EditorConfigPsiFile createDummyFile(CharSequence content) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(".editorconfig", (FileType)EditorConfigFileType.INSTANCE, content);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.editorconfig.language.psi.EditorConfigPsiFile");
        return (EditorConfigPsiFile)psiFile;
    }

    @Override
    @NotNull
    public EditorConfigRootDeclaration createRootDeclaration(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = this.createDummyFile(EditorConfigFileConstants.INSTANCE.getRootDeclarationFor(file)).getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.editorconfig.language.psi.EditorConfigRootDeclaration");
        return (EditorConfigRootDeclaration)psiElement;
    }

    @Override
    @NotNull
    public EditorConfigSection createSection(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return (EditorConfigSection)CollectionsKt.single(this.createDummyFile(source).getSections());
    }

    @Override
    @NotNull
    public EditorConfigHeader createHeader(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigHeader editorConfigHeader = this.createSection(source).getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
        return editorConfigHeader;
    }

    @Override
    @NotNull
    public EditorConfigPattern createPattern(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigPattern editorConfigPattern = this.createSection("[" + source + "]").getHeader().getPattern();
        Intrinsics.checkNotNull((Object)editorConfigPattern);
        return editorConfigPattern;
    }

    @Override
    @NotNull
    public EditorConfigCharClassPattern createCharClassPattern(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)this.createPattern(source), EditorConfigCharClassPattern.class, (boolean)false);
        Intrinsics.checkNotNull((Object)psiElement);
        return (EditorConfigCharClassPattern)psiElement;
    }

    @Override
    @NotNull
    public EditorConfigDescribableElement createAnyValue(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigDescribableElement editorConfigDescribableElement = this.createOption("foo=" + source).getAnyValue();
        Intrinsics.checkNotNull((Object)editorConfigDescribableElement);
        return editorConfigDescribableElement;
    }

    @Override
    @NotNull
    public EditorConfigOptionValueIdentifier createValueIdentifier(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.createOption("foo=" + source).getOptionValueIdentifier();
        Intrinsics.checkNotNull((Object)editorConfigOptionValueIdentifier);
        return editorConfigOptionValueIdentifier;
    }

    @Override
    @NotNull
    public EditorConfigOption createOption(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List<EditorConfigOption> list = this.createSection("[*]" + source).getOptionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOptionList(...)");
        return (EditorConfigOption)CollectionsKt.single(list);
    }

    @Override
    @NotNull
    public EditorConfigDescribableElement createKey(@NotNull CharSequence source) {
        EditorConfigDescribableElement editorConfigDescribableElement;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigOption option = this.createOption(source + "=bar");
        EditorConfigFlatOptionKey editorConfigFlatOptionKey = option.getFlatOptionKey();
        if (editorConfigFlatOptionKey != null) {
            editorConfigDescribableElement = editorConfigFlatOptionKey;
        } else {
            EditorConfigQualifiedOptionKey editorConfigQualifiedOptionKey = option.getQualifiedOptionKey();
            if (editorConfigQualifiedOptionKey != null) {
                editorConfigDescribableElement = editorConfigQualifiedOptionKey;
            } else {
                throw new IllegalStateException();
            }
        }
        return editorConfigDescribableElement;
    }

    @Override
    @NotNull
    public EditorConfigQualifiedKeyPart createKeyPart(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigQualifiedOptionKey editorConfigQualifiedOptionKey = this.createOption("hello." + source + "=value").getQualifiedOptionKey();
        Intrinsics.checkNotNull((Object)editorConfigQualifiedOptionKey);
        EditorConfigQualifiedKeyPart editorConfigQualifiedKeyPart = editorConfigQualifiedOptionKey.getQualifiedKeyPartList().get(1);
        Intrinsics.checkNotNull((Object)editorConfigQualifiedKeyPart);
        return editorConfigQualifiedKeyPart;
    }
}

