/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class DuplicateCharacterInClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateCharacterInClassInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateCharacterInClassVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection", "buildVisitor"));
    }

    private static class DuplicateCharacterInClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        DuplicateCharacterInClassVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                DuplicateCharacterInClassVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            PsiFile file = regExpClass.getContainingFile();
            if (file == null || Boolean.TRUE.equals(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION))) {
                return;
            }
            HashSet<Object> seen = new HashSet<Object>();
            for (RegExpClassElement element : regExpClass.getElements()) {
                this.checkForDuplicates(element, seen);
            }
        }

        private void checkForDuplicates(RegExpClassElement element, Set<Object> seen) {
            RegExpSimpleClass regExpSimpleClass;
            RegExpSimpleClass.Kind kind;
            if (element instanceof RegExpChar) {
                RegExpChar regExpChar = (RegExpChar)element;
                int value2 = regExpChar.getValue();
                if (value2 != -1 && !seen.add(value2)) {
                    this.myHolder.registerProblem((PsiElement)regExpChar, RegExpBundle.message("warning.duplicate.character.0.inside.character.class", regExpChar.getText()), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpChar)});
                }
            } else if (element instanceof RegExpSimpleClass && !seen.add((Object)(kind = (regExpSimpleClass = (RegExpSimpleClass)element).getKind()))) {
                String text2 = regExpSimpleClass.getText();
                this.myHolder.registerProblem((PsiElement)regExpSimpleClass, RegExpBundle.message("warning.duplicate.predefined.character.class.0.inside.character.class", text2), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpSimpleClass)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassVisitor", "<init>"));
        }
    }

    private static final class DuplicateCharacterInClassFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        private DuplicateCharacterInClassFix(RegExpElement predefinedCharacterClass) {
            this.myText = predefinedCharacterClass.getText();
        }

        @NotNull
        public String getName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.duplicate.0.from.character.class", this.myText);
            if (string2 == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.duplicate.element.from.character.class", new Object[0]);
            if (string2 == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        protected void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater2) {
            if (project2 == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(3);
            }
            if (updater2 == null) {
                DuplicateCharacterInClassFix.$$$reportNull$$$0(4);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/DuplicateCharacterInClassInspection$DuplicateCharacterInClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3, 4 -> new IllegalArgumentException(string2);
            };
        }
    }
}

