/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegExpLanguageHost {
    public static final EnumSet<RegExpGroup.Type> EMPTY_NAMED_GROUP_TYPES = EnumSet.noneOf(RegExpGroup.Type.class);
    public static final String[][] EMPTY_COMPLETION_ITEMS_ARRAY = new String[0][];

    @Deprecated
    default public boolean characterNeedsEscaping(char c) {
        throw new UnsupportedOperationException("Override characterNeedsEscaping(char, boolean)");
    }

    default public boolean characterNeedsEscaping(char c, boolean isInClass) {
        return this.characterNeedsEscaping(c);
    }

    public boolean supportsPerl5EmbeddedComments();

    public boolean supportsPossessiveQuantifiers();

    default public boolean isDuplicateGroupNamesAllowed(@NotNull RegExpGroup group2) {
        if (group2 == null) {
            RegExpLanguageHost.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean supportsPythonConditionalRefs();

    default public boolean supportConditionalCondition(RegExpAtom condition) {
        return true;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup var1);

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef var1);

    @NotNull
    default public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            RegExpLanguageHost.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar var1);

    default public boolean isValidGroupName(String name, @NotNull RegExpGroup group2) {
        if (group2 == null) {
            RegExpLanguageHost.$$$reportNull$$$0(2);
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (AsciiUtil.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    default public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        return true;
    }

    default public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return false;
    }

    default public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return this.supportsNamedCharacters(namedCharacter);
    }

    default public boolean supportsBoundary(RegExpBoundary boundary) {
        return switch (boundary.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case RegExpBoundary.Type.UNICODE_EXTENDED_GRAPHEME, RegExpBoundary.Type.RESET_MATCH -> false;
            case RegExpBoundary.Type.LINE_START, RegExpBoundary.Type.LINE_END, RegExpBoundary.Type.WORD, RegExpBoundary.Type.NON_WORD, RegExpBoundary.Type.BEGIN, RegExpBoundary.Type.END, RegExpBoundary.Type.END_NO_LINE_TERM, RegExpBoundary.Type.PREVIOUS_MATCH -> true;
        };
    }

    default public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return true;
    }

    default public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        return true;
    }

    public boolean isValidCategory(@NotNull String var1);

    default public boolean isValidPropertyName(@NotNull String name) {
        if (name == null) {
            RegExpLanguageHost.$$$reportNull$$$0(3);
        }
        return true;
    }

    default public boolean isValidPropertyValue(@NotNull String propertyName, @NotNull String value2) {
        if (propertyName == null) {
            RegExpLanguageHost.$$$reportNull$$$0(4);
        }
        if (value2 == null) {
            RegExpLanguageHost.$$$reportNull$$$0(5);
        }
        return true;
    }

    public String[] @NotNull [] getAllKnownProperties();

    @Nullable
    public String getPropertyDescription(@Nullable String var1);

    public String[] @NotNull [] getKnownCharacterClasses();

    @Nullable
    default public Number getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            RegExpLanguageHost.$$$reportNull$$$0(6);
        }
        return Double.parseDouble(number.getUnescapedText());
    }

    default public Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            RegExpLanguageHost.$$$reportNull$$$0(7);
        }
        return Lookbehind.FULL;
    }

    default public String[] @NotNull [] getAllPropertyValues(@NotNull String propertyName) {
        if (propertyName == null) {
            RegExpLanguageHost.$$$reportNull$$$0(8);
        }
        return EMPTY_COMPLETION_ITEMS_ARRAY;
    }

    default public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        if (context == null) {
            RegExpLanguageHost.$$$reportNull$$$0(9);
        }
        return true;
    }

    default public boolean belongsToConditionalExpression(@NotNull PsiElement element) {
        if (element == null) {
            RegExpLanguageHost.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicateGroupNamesAllowed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertyValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "supportsPropertySyntax";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "belongsToConditionalExpression";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    public static enum Lookbehind {
        NOT_SUPPORTED,
        FIXED_LENGTH_ALTERNATION,
        VARIABLE_LENGTH_ALTERNATION,
        FINITE_REPETITION,
        FULL;

    }
}

