/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.xsd.ComplexTypeComplexContentExtension;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSimpleContentExtension;
import com.thaiopensource.relaxng.output.xsd.NamespaceManager;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaTransformer;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ComplexTypeSelector
extends SchemaWalker {
    private final Map groupMap = new HashMap();
    private final Map attributeGroupMap = new HashMap();
    private final Map simpleTypeMap = new HashMap();
    private String parentDefinition;
    private Element parentElement;
    private int nonTypeReference = 0;
    private int undesirable = 0;
    private final Map complexTypeMap = new HashMap();
    private final Schema schema;
    private final Transformer transformer;
    private final ParticleVisitor baseFinder = new BaseFinder();

    ComplexTypeSelector(Schema schema) {
        this.schema = schema;
        this.transformer = new Transformer(schema);
        schema.accept(this);
        this.chooseComplexTypes(this.groupMap);
        this.chooseComplexTypes(this.simpleTypeMap);
    }

    public void visitGroup(GroupDefinition groupDefinition) {
        this.parentDefinition = groupDefinition.getName();
        groupDefinition.getParticle().accept(this);
        this.parentDefinition = null;
    }

    public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
        this.parentDefinition = simpleTypeDefinition.getName();
        simpleTypeDefinition.getSimpleType().accept(this);
        this.parentDefinition = null;
    }

    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        this.parentDefinition = attributeGroupDefinition.getName();
        attributeGroupDefinition.getAttributeUses().accept(this);
        this.parentDefinition = null;
    }

    public void visitRoot(RootDeclaration rootDeclaration) {
        ++this.undesirable;
        rootDeclaration.getParticle().accept(this);
        --this.undesirable;
    }

    public Object visitElement(Element element) {
        Element element2 = this.parentElement;
        int n = this.nonTypeReference;
        int n2 = this.undesirable;
        this.parentElement = element;
        this.nonTypeReference = 0;
        this.undesirable = 0;
        element.getComplexType().accept(this);
        this.undesirable = n2;
        this.nonTypeReference = n;
        this.parentElement = element2;
        return null;
    }

    public Object visitSequence(ParticleSequence particleSequence) {
        Iterator iterator = particleSequence.getChildren().iterator();
        ++this.undesirable;
        ((Particle)iterator.next()).accept(this);
        --this.undesirable;
        ++this.nonTypeReference;
        while (iterator.hasNext()) {
            ((Particle)iterator.next()).accept(this);
        }
        --this.nonTypeReference;
        return null;
    }

    public Object visitChoice(ParticleChoice particleChoice) {
        ++this.nonTypeReference;
        super.visitChoice(particleChoice);
        --this.nonTypeReference;
        return null;
    }

    public Object visitAll(ParticleAll particleAll) {
        ++this.nonTypeReference;
        super.visitAll(particleAll);
        --this.nonTypeReference;
        return null;
    }

    public Object visitRepeat(ParticleRepeat particleRepeat) {
        ++this.nonTypeReference;
        super.visitRepeat(particleRepeat);
        --this.nonTypeReference;
        return null;
    }

    public Object visitAttribute(Attribute attribute) {
        ++this.nonTypeReference;
        SimpleType simpleType = attribute.getType();
        if (simpleType != null) {
            simpleType.accept(this);
        }
        --this.nonTypeReference;
        return null;
    }

    public Object visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        super.visitComplexContent(complexTypeComplexContent);
        return null;
    }

    public Object visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        super.visitSimpleContent(complexTypeSimpleContent);
        return null;
    }

    public Object visitUnion(SimpleTypeUnion simpleTypeUnion) {
        ++this.nonTypeReference;
        super.visitUnion(simpleTypeUnion);
        --this.nonTypeReference;
        return null;
    }

    public Object visitList(SimpleTypeList simpleTypeList) {
        ++this.nonTypeReference;
        super.visitList(simpleTypeList);
        --this.nonTypeReference;
        return null;
    }

    public Object visitGroupRef(GroupRef groupRef) {
        this.noteRef(this.groupMap, groupRef.getName());
        return null;
    }

    public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        this.noteRef(this.attributeGroupMap, attributeGroupRef.getName());
        return null;
    }

    public Object visitRef(SimpleTypeRef simpleTypeRef) {
        ++this.undesirable;
        this.noteRef(this.simpleTypeMap, simpleTypeRef.getName());
        --this.undesirable;
        return null;
    }

    private void noteRef(Map map2, String string2) {
        Refs refs = ComplexTypeSelector.lookupRefs(map2, string2);
        if (this.nonTypeReference > 0) {
            refs.nonTypeReference = true;
        } else if (this.parentElement != null) {
            refs.referencingElements.add(this.parentElement);
        } else if (this.parentDefinition != null) {
            refs.referencingDefinitions.add(this.parentDefinition);
        }
        if (this.undesirable == 0) {
            refs.desirable = true;
        }
    }

    private static Refs lookupRefs(Map map2, String string2) {
        Refs refs = (Refs)map2.get(string2);
        if (refs == null) {
            refs = new Refs();
            map2.put(string2, refs);
        }
        return refs;
    }

    private void chooseComplexTypes(Map map2) {
        boolean bl;
        do {
            bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                String string2 = (String)entry2.getKey();
                if (!this.createComplexType(string2, (Refs)entry2.getValue(), (Refs)this.attributeGroupMap.get(string2))) continue;
                bl = true;
            }
        } while (bl);
    }

    private boolean createComplexType(String string2, Refs refs, Refs refs2) {
        if (this.complexTypeMap.get(string2) != null) {
            return false;
        }
        if (refs.nonTypeReference) {
            return false;
        }
        if (refs2 == null ? !refs.desirable : !refs2.referencingDefinitions.equals(refs.referencingDefinitions) || !refs2.referencingElements.equals(refs.referencingElements)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = refs.referencingElements.iterator();
        while (iterator.hasNext()) {
            boolean bl3 = ((Element)iterator.next()).getComplexType().isMixed();
            if (bl3 != bl) {
                if (bl2) {
                    return false;
                }
                bl = bl3;
            }
            bl2 = true;
        }
        Iterator iterator2 = refs.referencingDefinitions.iterator();
        while (iterator2.hasNext()) {
            NamedComplexType namedComplexType = (NamedComplexType)this.complexTypeMap.get(iterator2.next());
            if (namedComplexType == null) {
                return false;
            }
            if (namedComplexType.mixed != bl) {
                if (bl2) {
                    return false;
                }
                bl = namedComplexType.mixed;
            }
            bl2 = true;
        }
        this.complexTypeMap.put(string2, new NamedComplexType(bl));
        return true;
    }

    private Particle transformParticle(Particle particle) {
        if (particle == null) {
            return particle;
        }
        return (Particle)particle.accept(this.transformer);
    }

    private AttributeUse transformAttributeUses(AttributeUse attributeUse) {
        return (AttributeUse)attributeUse.accept(this.transformer);
    }

    String particleBase(Particle particle) {
        if (particle == null) {
            return null;
        }
        return (String)particle.accept(this.baseFinder);
    }

    ComplexTypeComplexContentExtension transformComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        String string2 = this.particleBase(complexTypeComplexContent.getParticle());
        if (string2 != null) {
            Particle particle = this.transformParticle(complexTypeComplexContent.getParticle());
            return new ComplexTypeComplexContentExtension(this.transformAttributeUses(complexTypeComplexContent.getAttributeUses()), particle, particle != null && complexTypeComplexContent.isMixed(), string2);
        }
        return new ComplexTypeComplexContentExtension(complexTypeComplexContent);
    }

    ComplexTypeSimpleContentExtension transformSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        String string2;
        NamedComplexType namedComplexType;
        SimpleType simpleType = complexTypeSimpleContent.getSimpleType();
        if (simpleType instanceof SimpleTypeRef && (namedComplexType = (NamedComplexType)this.complexTypeMap.get(string2 = ((SimpleTypeRef)simpleType).getName())) != null) {
            return new ComplexTypeSimpleContentExtension(this.transformAttributeUses(complexTypeSimpleContent.getAttributeUses()), null, string2);
        }
        return new ComplexTypeSimpleContentExtension(complexTypeSimpleContent);
    }

    ComplexTypeComplexContentExtension createComplexTypeForGroup(String string2, NamespaceManager namespaceManager) {
        NamedComplexType namedComplexType = (NamedComplexType)this.complexTypeMap.get(string2);
        if (namedComplexType == null) {
            return null;
        }
        AttributeGroupDefinition attributeGroupDefinition = this.schema.getAttributeGroup(string2);
        AttributeUse attributeUse = attributeGroupDefinition == null ? AttributeGroup.EMPTY : attributeGroupDefinition.getAttributeUses();
        GroupDefinition groupDefinition = this.schema.getGroup(string2);
        if (namespaceManager.getGroupDefinitionAbstractElementName(groupDefinition) != null) {
            return new ComplexTypeComplexContentExtension(attributeUse, new GroupRef(groupDefinition.getParticle().getLocation(), null, string2), namedComplexType.mixed, null);
        }
        return this.transformComplexContent(new ComplexTypeComplexContent(attributeUse, groupDefinition.getParticle(), namedComplexType.mixed));
    }

    ComplexTypeSimpleContentExtension createComplexTypeForSimpleType(String string2) {
        NamedComplexType namedComplexType = (NamedComplexType)this.complexTypeMap.get(string2);
        if (namedComplexType == null) {
            return null;
        }
        AttributeGroupDefinition attributeGroupDefinition = this.schema.getAttributeGroup(string2);
        AttributeUse attributeUse = attributeGroupDefinition == null ? AttributeGroup.EMPTY : attributeGroupDefinition.getAttributeUses();
        return this.transformSimpleContent(new ComplexTypeSimpleContent(attributeUse, this.schema.getSimpleType(string2).getSimpleType()));
    }

    boolean isComplexType(String string2) {
        return this.complexTypeMap.get(string2) != null;
    }

    class BaseFinder
    implements ParticleVisitor {
        BaseFinder() {
        }

        public Object visitGroupRef(GroupRef groupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(groupRef.getName()) != null) {
                return groupRef.getName();
            }
            return null;
        }

        public Object visitSequence(ParticleSequence particleSequence) {
            return ((Particle)particleSequence.getChildren().get(0)).accept(this);
        }

        public Object visitElement(Element element) {
            return null;
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            return null;
        }

        public Object visitRepeat(ParticleRepeat particleRepeat) {
            return null;
        }

        public Object visitChoice(ParticleChoice particleChoice) {
            return null;
        }

        public Object visitAll(ParticleAll particleAll) {
            return null;
        }
    }

    class Transformer
    extends SchemaTransformer {
        Transformer(Schema schema) {
            super(schema);
        }

        public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(attributeGroupRef.getName()) != null) {
                return AttributeGroup.EMPTY;
            }
            return attributeGroupRef;
        }

        public Object visitGroupRef(GroupRef groupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(groupRef.getName()) != null) {
                return null;
            }
            return groupRef;
        }

        public Object visitElement(Element element) {
            return element;
        }

        public Object visitAttribute(Attribute attribute) {
            return attribute;
        }
    }

    static class NamedComplexType {
        private final boolean mixed;

        NamedComplexType(boolean bl) {
            this.mixed = bl;
        }
    }

    static class Refs {
        final Set referencingElements = new HashSet();
        final Set referencingDefinitions = new HashSet();
        boolean nonTypeReference = false;
        boolean desirable = false;

        Refs() {
        }
    }
}

