/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GrammarPart
implements ComponentVisitor {
    private final ErrorReporter er;
    private final Map defines;
    private final Set attlists;
    private final Set implicitlyCombinedDefines;
    private final Map combineTypes;
    private final SchemaCollection schemas;
    private final Map parts;
    private final Map whereProvided = new HashMap();
    private final Set pendingIncludes;

    GrammarPart(ErrorReporter errorReporter, Map map2, Set set, SchemaCollection schemaCollection, Map map3, GrammarPattern grammarPattern) {
        this.er = errorReporter;
        this.defines = map2;
        this.attlists = set;
        this.schemas = schemaCollection;
        this.parts = map3;
        this.pendingIncludes = new HashSet();
        this.implicitlyCombinedDefines = new HashSet();
        this.combineTypes = new HashMap();
        this.visitContainer(grammarPattern);
    }

    private GrammarPart(GrammarPart grammarPart, GrammarPattern grammarPattern) {
        this.er = grammarPart.er;
        this.defines = grammarPart.defines;
        this.schemas = grammarPart.schemas;
        this.parts = grammarPart.parts;
        this.attlists = grammarPart.attlists;
        this.pendingIncludes = grammarPart.pendingIncludes;
        this.implicitlyCombinedDefines = grammarPart.implicitlyCombinedDefines;
        this.combineTypes = grammarPart.combineTypes;
        this.visitContainer(grammarPattern);
    }

    Set providedSet() {
        return this.whereProvided.keySet();
    }

    public Object visitContainer(Container container) {
        List list2 = container.getComponents();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            ((Component)list2.get(n)).accept(this);
            ++n;
        }
        return null;
    }

    public Object visitDiv(DivComponent divComponent) {
        return this.visitContainer(divComponent);
    }

    public Object visitDefine(DefineComponent defineComponent) {
        Object object;
        String string2 = defineComponent.getName();
        Combine combine2 = defineComponent.getCombine();
        if (combine2 == null) {
            if (this.implicitlyCombinedDefines.contains(string2)) {
                this.er.error("multiple_no_combine", string2, defineComponent.getSourceLocation());
            } else {
                this.implicitlyCombinedDefines.add(string2);
            }
        } else {
            object = (Combine)this.combineTypes.get(string2);
            if (object != null) {
                if (object != combine2) {
                    this.er.error("inconsistent_combine", defineComponent.getSourceLocation());
                }
            } else {
                this.combineTypes.put(string2, combine2);
            }
        }
        object = (Pattern)this.defines.get(string2);
        if (object != null) {
            if (combine2 == Combine.CHOICE) {
                this.er.error("sorry_combine_choice", defineComponent.getSourceLocation());
            } else if (combine2 == Combine.INTERLEAVE) {
                InterleavePattern interleavePattern = new InterleavePattern();
                interleavePattern.getChildren().add(object);
                interleavePattern.getChildren().add(defineComponent.getBody());
                interleavePattern.setSourceLocation(defineComponent.getSourceLocation());
                this.defines.put(string2, interleavePattern);
                this.attlists.add(string2);
            }
        } else {
            this.defines.put(string2, defineComponent.getBody());
            this.whereProvided.put(string2, defineComponent);
        }
        return null;
    }

    public Object visitInclude(IncludeComponent includeComponent) {
        String string2 = includeComponent.getHref();
        if (this.pendingIncludes.contains(string2)) {
            throw new IncludeLoopException(includeComponent);
        }
        this.pendingIncludes.add(string2);
        GrammarPattern grammarPattern = (GrammarPattern)((SchemaDocument)this.schemas.getSchemaDocumentMap().get(string2)).getPattern();
        GrammarPart grammarPart = new GrammarPart(this, grammarPattern);
        this.parts.put(string2, grammarPart);
        Iterator iterator = grammarPart.providedSet().iterator();
        while (iterator.hasNext()) {
            this.whereProvided.put((String)iterator.next(), includeComponent);
        }
        this.pendingIncludes.remove(string2);
        return null;
    }

    Component getWhereProvided(String string2) {
        return (Component)this.whereProvided.get(string2);
    }

    public static class IncludeLoopException
    extends RuntimeException {
        private final IncludeComponent include;

        public IncludeLoopException(IncludeComponent includeComponent) {
            this.include = includeComponent;
        }

        public IncludeComponent getInclude() {
            return this.include;
        }
    }
}

