/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.SAXException;

class OneOrMorePattern
extends Pattern {
    private final Pattern p;

    OneOrMorePattern(Pattern pattern2) {
        super(pattern2.isNullable(), pattern2.getContentType(), Pattern.combineHashCode(19, pattern2.hashCode()));
        this.p = pattern2;
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern2 = this.p.expand(schemaPatternBuilder);
        if (pattern2 != this.p) {
            return schemaPatternBuilder.makeOneOrMore(pattern2);
        }
        return this;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(n == 1 ? 2 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !Pattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }

    boolean samePattern(Pattern pattern2) {
        return pattern2 instanceof OneOrMorePattern && this.p == ((OneOrMorePattern)pattern2).p;
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitOneOrMore(this.p);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseOneOrMore(this);
    }

    Pattern getOperand() {
        return this.p;
    }
}

