/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.wiremock;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\r\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"WIREMOCK_FILES", "", "WIREMOCK_PLUGIN_ID", "WIREMOCK_PLUGIN_NAME", "WIREMOCK_SUGGESTION_DISMISSED_KEY", "detectWireMockStubs", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dismissPluginSuggestion", "", "isPluginSuggestionDismissed", "isWireMockJson", "Lcom/intellij/psi/PsiFile;", "looksLikeWireMockFile", "psiFile", "Lcom/intellij/json/psi/JsonFile;", "intellij.json"})
public final class WireMockSuggestionProviderKt {
    @NotNull
    private static final String WIREMOCK_PLUGIN_ID = "com.intellij.wiremock";
    @NotNull
    private static final String WIREMOCK_PLUGIN_NAME = "WireMock";
    @NotNull
    private static final String WIREMOCK_FILES = "WireMock";
    @NotNull
    private static final String WIREMOCK_SUGGESTION_DISMISSED_KEY = "wiremock.suggestion.dismissed";

    private static final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue(WIREMOCK_SUGGESTION_DISMISSED_KEY, true);
    }

    private static final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue(WIREMOCK_SUGGESTION_DISMISSED_KEY);
    }

    private static final boolean detectWireMockStubs(Project project2, VirtualFile file) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file);
        return WireMockSuggestionProviderKt.isWireMockJson(psiFile2);
    }

    private static final boolean isWireMockJson(PsiFile file) {
        if (!(file instanceof JsonFile)) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> WireMockSuggestionProviderKt.isWireMockJson$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean looksLikeWireMockFile(JsonFile psiFile2) {
        JsonValue topLevelValue;
        if (psiFile2.getParent() != null) {
            PsiDirectory psiDirectory = (PsiDirectory)psiFile2.getParent();
            if (Intrinsics.areEqual((Object)(psiDirectory != null ? psiDirectory.getName() : null), (Object)"mappings")) {
                JsonValue jsonValue = psiFile2.getTopLevelValue();
                JsonObject jsonObject = jsonValue instanceof JsonObject ? (JsonObject)jsonValue : null;
                if ((jsonObject != null ? jsonObject.findProperty("request") : null) != null) {
                    return true;
                }
            }
        }
        if (!((topLevelValue = psiFile2.getTopLevelValue()) instanceof JsonObject)) return false;
        JsonProperty jsonProperty = ((JsonObject)topLevelValue).findProperty("mappings");
        if (!((jsonProperty != null ? jsonProperty.getValue() : null) instanceof JsonArray)) return false;
        return true;
    }

    private static final CachedValueProvider.Result isWireMockJson$lambda$0(PsiFile $file) {
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result((Object)WireMockSuggestionProviderKt.looksLikeWireMockFile((JsonFile)$file), objectArray);
    }

    public static final /* synthetic */ boolean access$isPluginSuggestionDismissed() {
        return WireMockSuggestionProviderKt.isPluginSuggestionDismissed();
    }

    public static final /* synthetic */ boolean access$detectWireMockStubs(Project project2, VirtualFile file) {
        return WireMockSuggestionProviderKt.detectWireMockStubs(project2, file);
    }

    public static final /* synthetic */ void access$dismissPluginSuggestion() {
        WireMockSuggestionProviderKt.dismissPluginSuggestion();
    }
}

