/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonFileResolver {
    private static final Key<Boolean> DOWNLOAD_STARTED = Key.create((String)"DOWNLOAD_STARTED");
    private static final LoadingCache<String, VirtualFile> urlValidityCache = Caffeine.newBuilder().expireAfterAccess((long)Registry.intValue((String)"remote.schema.cache.validity.duration", (int)1), TimeUnit.MINUTES).maximumSize(1000L).executor(SameThreadExecutor.INSTANCE).build(JsonFileResolver::computeVirtualFileForValidUrlOrNull);
    private static final String MOCK_URL = "mock:///";
    public static final String TEMP_URL = "temp:///";

    public static boolean isRemoteEnabled(Project project2) {
        return !"true".equals(System.getProperty("idea.is.integration.test")) && !ApplicationManager.getApplication().isUnitTestMode() && JsonSchemaCatalogProjectConfiguration.getInstance(project2).isRemoteActivityEnabled();
    }

    @Nullable
    public static VirtualFile urlToFile(@NotNull String urlString) {
        if (urlString == null) {
            JsonFileResolver.$$$reportNull$$$0(0);
        }
        if (urlString.startsWith(TEMP_URL)) {
            return TempFileSystem.getInstance().findFileByPath(urlString.substring(TEMP_URL.length() - 1));
        }
        return VirtualFileManager.getInstance().findFileByUrl(FileUtil.toSystemIndependentName((String)JsonFileResolver.replaceUnsafeSchemaStoreUrls(urlString)));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String replaceUnsafeSchemaStoreUrls(@Nullable String urlString) {
        if (urlString == null) {
            return null;
        }
        if (urlString.equals("http://schemastore.org/api/json/catalog.json")) {
            return "https://schemastore.org/api/json/catalog.json";
        }
        if (StringUtil.startsWithIgnoreCase((String)urlString, (String)"http://json.schemastore.org")) {
            String newUrl = StringUtil.replace((String)urlString, (String)"http://json.schemastore.org/", (String)"https://schemastore.azurewebsites.net/schemas/json/");
            return newUrl.endsWith(".json") ? newUrl : newUrl + ".json";
        }
        return urlString;
    }

    @Nullable
    public static VirtualFile resolveSchemaByReference(@Nullable VirtualFile currentFile, @Nullable String schemaUrl) {
        if (schemaUrl == null || StringUtil.isEmpty((String)schemaUrl)) {
            return null;
        }
        boolean isHttpPath = JsonFileResolver.isHttpPath((String)schemaUrl);
        if (!isHttpPath && currentFile instanceof HttpVirtualFile) {
            String url = StringUtil.trimEnd((String)currentFile.getUrl(), (String)"/");
            int lastSlash = url.lastIndexOf(47);
            assert (lastSlash != -1);
            schemaUrl = url.substring(0, lastSlash) + "/" + (String)schemaUrl;
        } else if (StringUtil.startsWithChar((CharSequence)schemaUrl, (char)'.') || !isHttpPath) {
            VirtualFile parent;
            VirtualFile virtualFile = parent = currentFile == null ? null : currentFile.getParent();
            Object object = parent == null ? null : (schemaUrl = parent.getUrl().startsWith(TEMP_URL) ? TEMP_URL + parent.getPath() + "/" + (String)schemaUrl : VfsUtilCore.pathToUrl((String)(parent.getPath() + File.separator + (String)schemaUrl)));
        }
        if (StringUtil.isEmpty((String)schemaUrl)) {
            return null;
        }
        if (!((String)schemaUrl).startsWith("http")) {
            return JsonFileResolver.urlToFile((String)schemaUrl);
        }
        return JsonFileResolver.getOrComputeVirtualFileForValidUrlOrNull((String)schemaUrl);
    }

    @Nullable
    private static VirtualFile getOrComputeVirtualFileForValidUrlOrNull(@NotNull String maybeUrl) {
        if (maybeUrl == null) {
            JsonFileResolver.$$$reportNull$$$0(1);
        }
        return (VirtualFile)urlValidityCache.get((Object)maybeUrl);
    }

    @Nullable
    private static VirtualFile computeVirtualFileForValidUrlOrNull(@NotNull String url) {
        Url parse;
        if (url == null) {
            JsonFileResolver.$$$reportNull$$$0(2);
        }
        if ((parse = Urls.parse((String)url, (boolean)false)) == null || StringUtil.isEmpty((String)parse.getAuthority()) || StringUtil.isEmpty((String)parse.getPath())) {
            return null;
        }
        return JsonFileResolver.urlToFile(url);
    }

    public static void startFetchingHttpFileIfNeeded(@Nullable VirtualFile path2, Project project2) {
        if (!(path2 instanceof HttpVirtualFile)) {
            return;
        }
        if (!JsonFileResolver.isRemoteEnabled(project2)) {
            return;
        }
        RemoteFileInfo info = ((HttpVirtualFile)path2).getFileInfo();
        if ((info == null || info.getState() == RemoteFileState.DOWNLOADING_NOT_STARTED) && path2.getUserData(DOWNLOAD_STARTED) != Boolean.TRUE) {
            path2.putUserData(DOWNLOAD_STARTED, (Object)Boolean.TRUE);
            path2.refresh(true, false);
        }
    }

    public static boolean isHttpPath(@NotNull String schemaFieldText) {
        if (schemaFieldText == null) {
            JsonFileResolver.$$$reportNull$$$0(3);
        }
        return schemaFieldText.startsWith("http://") || schemaFieldText.startsWith("https://");
    }

    public static boolean isAbsoluteUrl(@NotNull String path2) {
        if (path2 == null) {
            JsonFileResolver.$$$reportNull$$$0(4);
        }
        return JsonFileResolver.isHttpPath(path2) || path2.startsWith(TEMP_URL) || FileUtil.toSystemIndependentName((String)path2).startsWith("jar://");
    }

    public static boolean isTempOrMockUrl(@NotNull String path2) {
        if (path2 == null) {
            JsonFileResolver.$$$reportNull$$$0(5);
        }
        return path2.startsWith(TEMP_URL) || path2.startsWith(MOCK_URL);
    }

    public static boolean isSchemaUrl(@Nullable String url) {
        return url != null && url.startsWith("http://json-schema.org/") && (url.endsWith("/schema") || url.endsWith("/schema#"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFieldText";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonFileResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "urlToFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrComputeVirtualFileForValidUrlOrNull";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeVirtualFileForValidUrlOrNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTempOrMockUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

