/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.patterns;

import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.patterns.ComplexPatternOptions;
import com.intellij.webSymbols.patterns.WebSymbolsPattern;
import com.intellij.webSymbols.patterns.impl.CompletionAutoPopupPattern;
import com.intellij.webSymbols.patterns.impl.ComplexPattern;
import com.intellij.webSymbols.patterns.impl.ComplexPatternConfigProvider;
import com.intellij.webSymbols.patterns.impl.RegExpPattern;
import com.intellij.webSymbols.patterns.impl.SequencePattern;
import com.intellij.webSymbols.patterns.impl.SingleSymbolReferencePattern;
import com.intellij.webSymbols.patterns.impl.StaticPattern;
import com.intellij.webSymbols.patterns.impl.SymbolReferencePattern;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006Jf\u0010\u0007\u001a\u00020\u00042<\u0010\b\u001a8\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0013J/\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0019\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0013J\u001f\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0019\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0006J\u0014\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0015J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u001fJ\u0012\u0010&\u001a\u00020\u00042\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u001f\u00a8\u0006("}, d2={"Lcom/intellij/webSymbols/patterns/WebSymbolsPatternFactory;", "", "()V", "createCompletionAutoPopup", "Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "isSticky", "", "createComplexPattern", "optionsProvider", "Lkotlin/Function2;", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "Lkotlin/ParameterName;", "name", "queryExecutor", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "contextStack", "Lcom/intellij/webSymbols/patterns/ComplexPatternOptions;", "isStaticAndRequiredProvider", "Lkotlin/Function0;", "patternsProvider", "", "options", "isStaticAndRequired", "patterns", "", "(Lcom/intellij/webSymbols/patterns/ComplexPatternOptions;Z[Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;)Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "createPatternSequence", "([Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;)Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "createRegExMatch", "regex", "", "caseSensitive", "createSingleSymbolReferencePattern", "path", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "createStringMatch", "content", "createSymbolReferencePlaceholder", "displayName", "intellij.platform.webSymbols"})
public final class WebSymbolsPatternFactory {
    @NotNull
    public static final WebSymbolsPatternFactory INSTANCE = new WebSymbolsPatternFactory();

    private WebSymbolsPatternFactory() {
    }

    @NotNull
    public final WebSymbolsPattern createComplexPattern(@NotNull Function2<? super WebSymbolsQueryExecutor, ? super Stack<WebSymbolsScope>, ComplexPatternOptions> optionsProvider, @NotNull Function0<Boolean> isStaticAndRequiredProvider, @NotNull Function0<? extends List<? extends WebSymbolsPattern>> patternsProvider) {
        Intrinsics.checkNotNullParameter(optionsProvider, (String)"optionsProvider");
        Intrinsics.checkNotNullParameter(isStaticAndRequiredProvider, (String)"isStaticAndRequiredProvider");
        Intrinsics.checkNotNullParameter(patternsProvider, (String)"patternsProvider");
        return new ComplexPattern(new ComplexPatternConfigProvider(patternsProvider, optionsProvider, isStaticAndRequiredProvider){
            final /* synthetic */ Function0<List<WebSymbolsPattern>> $patternsProvider;
            final /* synthetic */ Function2<WebSymbolsQueryExecutor, Stack<WebSymbolsScope>, ComplexPatternOptions> $optionsProvider;
            final /* synthetic */ Function0<Boolean> $isStaticAndRequiredProvider;
            {
                this.$patternsProvider = $patternsProvider;
                this.$optionsProvider = $optionsProvider;
                this.$isStaticAndRequiredProvider = $isStaticAndRequiredProvider;
            }

            @NotNull
            public List<WebSymbolsPattern> getPatterns() {
                return (List)this.$patternsProvider.invoke();
            }

            @NotNull
            public ComplexPatternOptions getOptions(@NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull Stack<WebSymbolsScope> scopeStack) {
                Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
                Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
                return (ComplexPatternOptions)this.$optionsProvider.invoke((Object)queryExecutor, scopeStack);
            }

            public boolean isStaticAndRequired() {
                return (Boolean)this.$isStaticAndRequiredProvider.invoke();
            }
        });
    }

    @NotNull
    public final WebSymbolsPattern createComplexPattern(@NotNull ComplexPatternOptions options, boolean isStaticAndRequired, WebSymbolsPattern ... patterns) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)patterns, (String)"patterns");
        return new ComplexPattern(new ComplexPatternConfigProvider(patterns, options, isStaticAndRequired){
            final /* synthetic */ WebSymbolsPattern[] $patterns;
            final /* synthetic */ ComplexPatternOptions $options;
            final /* synthetic */ boolean $isStaticAndRequired;
            {
                this.$patterns = $patterns;
                this.$options = $options;
                this.$isStaticAndRequired = $isStaticAndRequired;
            }

            @NotNull
            public List<WebSymbolsPattern> getPatterns() {
                return ArraysKt.toList((Object[])this.$patterns);
            }

            @NotNull
            public ComplexPatternOptions getOptions(@NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull Stack<WebSymbolsScope> scopeStack) {
                Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
                Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
                return this.$options;
            }

            public boolean isStaticAndRequired() {
                return this.$isStaticAndRequired;
            }
        });
    }

    @NotNull
    public final WebSymbolsPattern createPatternSequence(WebSymbolsPattern ... patterns) {
        Intrinsics.checkNotNullParameter((Object)patterns, (String)"patterns");
        return new SequencePattern((Function0<? extends List<? extends WebSymbolsPattern>>)((Function0)new Function0<List<? extends WebSymbolsPattern>>(patterns){
            final /* synthetic */ WebSymbolsPattern[] $patterns;
            {
                this.$patterns = $patterns;
                super(0);
            }

            @NotNull
            public final List<WebSymbolsPattern> invoke() {
                return ArraysKt.toList((Object[])this.$patterns);
            }
        }));
    }

    @NotNull
    public final WebSymbolsPattern createPatternSequence(@NotNull Function0<? extends List<? extends WebSymbolsPattern>> patternsProvider) {
        Intrinsics.checkNotNullParameter(patternsProvider, (String)"patternsProvider");
        return new SequencePattern(patternsProvider);
    }

    @NotNull
    public final WebSymbolsPattern createSymbolReferencePlaceholder(@Nullable String displayName) {
        return new SymbolReferencePattern(displayName);
    }

    public static /* synthetic */ WebSymbolsPattern createSymbolReferencePlaceholder$default(WebSymbolsPatternFactory webSymbolsPatternFactory, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return webSymbolsPatternFactory.createSymbolReferencePlaceholder(string2);
    }

    @NotNull
    public final WebSymbolsPattern createStringMatch(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new StaticPattern(content);
    }

    @NotNull
    public final WebSymbolsPattern createRegExMatch(@NotNull String regex, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegExpPattern(regex, caseSensitive);
    }

    public static /* synthetic */ WebSymbolsPattern createRegExMatch$default(WebSymbolsPatternFactory webSymbolsPatternFactory, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return webSymbolsPatternFactory.createRegExMatch(string2, bl);
    }

    @NotNull
    public final WebSymbolsPattern createCompletionAutoPopup(boolean isSticky) {
        return new CompletionAutoPopupPattern(isSticky);
    }

    @NotNull
    public final WebSymbolsPattern createSingleSymbolReferencePattern(@NotNull List<WebSymbolQualifiedName> path2) {
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        return new SingleSymbolReferencePattern(CollectionsKt.toList((Iterable)path2), false, false, 6, null);
    }
}

