/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J\u001c\u0010\u001c\u001a\u00020\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001eH&J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J \u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 \u0012\u0004\u0012\u00020\u00100#2\u0006\u0010$\u001a\u00020%R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/util/RevisionCollectorTask;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "_revisions", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "exception", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vcs/VcsException;", "future", "Ljava/util/concurrent/Future;", "isCancelled", "", "()Z", "lastSnapshotSize", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "revisionsCount", "getRevisionsCount", "()I", "cancel", "", "wait", "collectRevisions", "consumer", "Lkotlin/Function1;", "getRevisionsSnapshot", "", "throwOnError", "waitForRevisions", "Lkotlin/Pair;", "intervalMs", "", "intellij.platform.vcs.log.impl"})
public abstract class RevisionCollectorTask<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final ProgressIndicator indicator;
    @NotNull
    private final Future<?> future;
    @NotNull
    private final ConcurrentLinkedQueue<T> _revisions;
    @NotNull
    private final AtomicReference<VcsException> exception;
    private volatile int lastSnapshotSize;

    public RevisionCollectorTask(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.project = project2;
        this.indicator = indicator;
        this._revisions = new ConcurrentLinkedQueue();
        this.exception = new AtomicReference();
        Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(() -> RevisionCollectorTask._init_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
        this.future = future2;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public final boolean isCancelled() {
        return this.indicator.isCanceled();
    }

    protected final int getRevisionsCount() {
        return this._revisions.size();
    }

    public abstract void collectRevisions(@NotNull Function1<? super T, Unit> var1) throws VcsException;

    @NotNull
    public final Pair<List<T>, Boolean> waitForRevisions(long intervalMs) throws VcsException {
        this.throwOnError();
        while (this._revisions.size() == this.lastSnapshotSize) {
            try {
                this.future.get(intervalMs, TimeUnit.MILLISECONDS);
                ProgressManager.checkCanceled();
                this.throwOnError();
                return new Pair(this.getRevisionsSnapshot(), (Object)true);
            }
            catch (TimeoutException timeoutException) {
                ProgressManager.checkCanceled();
            }
        }
        return new Pair(this.getRevisionsSnapshot(), (Object)false);
    }

    private final List<T> getRevisionsSnapshot() {
        List list2 = CollectionsKt.toList((Iterable)this._revisions);
        this.lastSnapshotSize = list2.size();
        return list2;
    }

    private final void throwOnError() throws VcsException {
        if (this.exception.get() != null) {
            throw new VcsException(this.exception.get());
        }
    }

    public final void cancel(boolean wait) {
        this.indicator.cancel();
        if (wait) {
            try {
                this.future.get(20L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final void lambda$1$lambda$0(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.collectRevisions((Function1)new Function1<T, Unit>(this$0){
                final /* synthetic */ RevisionCollectorTask<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(T it) {
                    RevisionCollectorTask.access$get_revisions$p(this.this$0).add(it);
                }
            });
        }
        catch (VcsException e) {
            this$0.exception.set(e);
        }
    }

    private static final void _init_$lambda$1(RevisionCollectorTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProgressManager.getInstance().runProcess(() -> RevisionCollectorTask.lambda$1$lambda$0(this$0), this$0.indicator);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$get_revisions$p(RevisionCollectorTask $this) {
        return $this._revisions;
    }
}

