/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0006\u0010\u0007\u001a\u00020\u0006\u001a2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a(\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a,\u0010\u0016\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a8\u0006\u001a"}, d2={"getCorrectedPath", "Lcom/intellij/openapi/vcs/FilePath;", "project", "Lcom/intellij/openapi/project/Project;", "path", "isRevisionHistory", "", "isNewHistoryEnabled", "selectRowWhenOpen", "", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "firstTime", "triggerFileHistoryUsage", "paths", "", "jumpToNearestCommit", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "silently", "intellij.platform.vcs.log.impl"})
public final class VcsLogFileHistoryProviderImplKt {
    public static final boolean isNewHistoryEnabled() {
        return Registry.is((String)"vcs.new.history");
    }

    private static final void selectRowWhenOpen(VcsLogManager logManager2, Hash hash2, VirtualFile root, VcsLogUiEx ui2, boolean firstTime) {
        if (hash2 != null) {
            VcsLogStorage vcsLogStorage = logManager2.getDataManager().getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
            VcsLogFileHistoryProviderImplKt.jumpToNearestCommit(ui2, vcsLogStorage, hash2, root, true);
        } else if (firstTime) {
            VcsLogNavigationUtil.jumpToRow(ui2, 0, true, true);
        }
    }

    private static final void jumpToNearestCommit(VcsLogUiEx $this$jumpToNearestCommit, VcsLogStorage storage, Hash hash2, VirtualFile root, boolean silently) {
        $this$jumpToNearestCommit.jumpTo(hash2, (arg_0, arg_1) -> VcsLogFileHistoryProviderImplKt.jumpToNearestCommit$lambda$0((Function2)new Function2<VisiblePack, Hash, Integer>(storage, root){
            final /* synthetic */ VcsLogStorage $storage;
            final /* synthetic */ VirtualFile $root;
            {
                this.$storage = $storage;
                this.$root = $root;
                super(2);
            }

            public final Integer invoke(@NotNull VisiblePack visiblePack, @Nullable Hash h) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
                Hash hash2 = h;
                Intrinsics.checkNotNull((Object)hash2);
                if (!this.$storage.containsCommit(new CommitId(hash2, this.$root))) {
                    return -1;
                }
                int commitIndex = this.$storage.getCommitIndex(h, this.$root);
                Integer rowIndex = visiblePack.getVisibleGraph().getVisibleRowIndex(commitIndex);
                if (rowIndex == null) {
                    rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, visiblePack);
                }
                if ((n = rowIndex) == null) {
                    n = -2;
                }
                return n;
            }
        }, arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), silently, true);
    }

    private static final FilePath getCorrectedPath(Project project2, FilePath path2, boolean isRevisionHistory) {
        if (isRevisionHistory) {
            return path2;
        }
        FilePath filePath = VcsUtil.getLastCommitPath(project2, path2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        return filePath;
    }

    private static final void triggerFileHistoryUsage(Project project2, Collection<? extends FilePath> paths, Hash hash2) {
        String kind = paths.size() > 1 ? "multiple" : (((FilePath)CollectionsKt.first((Iterable)paths)).isDirectory() ? "folder" : "file");
        VcsLogUsageTriggerCollector.triggerFileHistoryUsage(project2, kind, hash2 != null);
    }

    private static final Integer jumpToNearestCommit$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$triggerFileHistoryUsage(Project project2, Collection paths, Hash hash2) {
        VcsLogFileHistoryProviderImplKt.triggerFileHistoryUsage(project2, paths, hash2);
    }

    public static final /* synthetic */ void access$selectRowWhenOpen(VcsLogManager logManager2, Hash hash2, VirtualFile root, VcsLogUiEx ui2, boolean firstTime) {
        VcsLogFileHistoryProviderImplKt.selectRowWhenOpen(logManager2, hash2, root, ui2, firstTime);
    }

    public static final /* synthetic */ FilePath access$getCorrectedPath(Project project2, FilePath path2, boolean isRevisionHistory) {
        return VcsLogFileHistoryProviderImplKt.getCorrectedPath(project2, path2, isRevisionHistory);
    }
}

