/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0004\"#$%B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0007J\b\u0010!\u001a\u00020\u001fH\u0007R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001b\u001a\f0\u001c\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "roots", "", "vcsLogProgress", "Lcom/intellij/vcs/log/data/VcsLogProgress;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Ljava/util/Set;Lcom/intellij/vcs/log/data/VcsLogProgress;)V", "alarm", "Lkotlin/Lazy;", "Lcom/intellij/util/Alarm;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "progress", "Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyProgressIndicator;", "statusBar", "Lcom/intellij/openapi/wm/ex/StatusBarEx;", "getStatusBar", "()Lcom/intellij/openapi/wm/ex/StatusBarEx;", "statusBar$delegate", "Lkotlin/Lazy;", "vcsName", "", "Lorg/jetbrains/annotations/Nls;", "dispose", "", "start", "stop", "Companion", "MyProgressIndicator", "MyProgressListener", "MyTaskInfo", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogStatusBarProgress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogStatusBarProgress.kt\ncom/intellij/vcs/log/data/VcsLogStatusBarProgress\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1603#2,9:122\n1855#2:131\n1856#2:133\n1612#2:134\n1#3:132\n*S KotlinDebug\n*F\n+ 1 VcsLogStatusBarProgress.kt\ncom/intellij/vcs/log/data/VcsLogStatusBarProgress\n*L\n27#1:122,9\n27#1:131\n27#1:133\n27#1:134\n27#1:132\n*E\n"})
public final class VcsLogStatusBarProgress
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<VirtualFile> roots;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private final String vcsName;
    @NotNull
    private final Lazy statusBar$delegate;
    @NotNull
    private final Lazy<Alarm> alarm;
    @Nullable
    private MyProgressIndicator progress;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public VcsLogStatusBarProgress(@NotNull Project project2, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogProgress vcsLogProgress) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)vcsLogProgress, (String)"vcsLogProgress");
        this.roots = roots;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        Iterable iterable = this.roots;
        Project project3 = project2;
        VcsLogStatusBarProgress vcsLogStatusBarProgress = this;
        boolean $i$f$mapNotNull = false;
        void var7_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsLogProvider it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (logProviders.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        String string2 = VcsLogUtil.getVcsDisplayName(project3, list2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVcsDisplayName(...)");
        vcsLogStatusBarProgress.vcsName = string2;
        this.statusBar$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StatusBarEx>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final StatusBarEx invoke() {
                WindowManager windowManager = WindowManager.getInstance();
                Intrinsics.checkNotNull((Object)windowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.WindowManagerEx");
                IdeFrame ideFrame = ((WindowManagerEx)windowManager).findFrameFor(this.$project);
                Intrinsics.checkNotNull((Object)ideFrame);
                StatusBar statusBar2 = ideFrame.getStatusBar();
                Intrinsics.checkNotNull((Object)statusBar2, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.StatusBarEx");
                return (StatusBarEx)statusBar2;
            }
        }));
        this.alarm = LazyKt.lazy((Function0)((Function0)new Function0<Alarm>(this){
            final /* synthetic */ VcsLogStatusBarProgress this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Alarm invoke() {
                return new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.this$0);
            }
        }));
        vcsLogProgress.addProgressIndicatorListener(new MyProgressListener(), this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    private final StatusBarEx getStatusBar() {
        Lazy lazy = this.statusBar$delegate;
        return (StatusBarEx)lazy.getValue();
    }

    @RequiresEdt
    public final void start() {
        ((Alarm)this.alarm.getValue()).addRequest(() -> VcsLogStatusBarProgress.start$lambda$2(this), Registry.intValue((String)"vcs.log.index.progress.delay.millis"));
    }

    @RequiresEdt
    public final void stop() {
        if (this.alarm.isInitialized()) {
            ((Alarm)this.alarm.getValue()).cancelAllRequests();
        }
        MyProgressIndicator myProgressIndicator = this.progress;
        if (myProgressIndicator != null) {
            MyProgressIndicator p = myProgressIndicator;
            boolean bl = false;
            p.stop();
            p.finish(p.getTaskInfo$intellij_platform_vcs_log_impl());
        }
        this.progress = null;
    }

    public void dispose() {
        this.stop();
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$2(VcsLogStatusBarProgress this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.progress == null) {
            void p;
            MyProgressIndicator myProgressIndicator;
            MyProgressIndicator myProgressIndicator2 = myProgressIndicator = this$0.new MyProgressIndicator();
            VcsLogStatusBarProgress vcsLogStatusBarProgress = this$0;
            boolean bl = false;
            p.start();
            this$0.getStatusBar().addProgress((ProgressIndicatorEx)p, (TaskInfo)p.getTaskInfo$intellij_platform_vcs_log_impl());
            vcsLogStatusBarProgress.progress = myProgressIndicator;
        }
    }

    static {
        Logger logger = Logger.getInstance(VcsLogStatusBarProgress.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u0018\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyProgressIndicator;", "Lcom/intellij/openapi/progress/util/AbstractProgressIndicatorExBase;", "(Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;)V", "taskInfo", "Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyTaskInfo;", "Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;", "getTaskInfo$intellij_platform_vcs_log_impl", "()Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyTaskInfo;", "cancel", "", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogStatusBarProgress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogStatusBarProgress.kt\ncom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyProgressIndicator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1855#2,2:122\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 VcsLogStatusBarProgress.kt\ncom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyProgressIndicator\n*L\n99#1:122,2\n101#1:124\n101#1:125,3\n*E\n"})
    public final class MyProgressIndicator
    extends AbstractProgressIndicatorExBase {
        @NotNull
        private final MyTaskInfo taskInfo;

        public MyProgressIndicator() {
            this.taskInfo = new MyTaskInfo();
            this.setOwnerTask(this.taskInfo);
            this.dontStartActivity();
        }

        @NotNull
        public final MyTaskInfo getTaskInfo$intellij_platform_vcs_log_impl() {
            return this.taskInfo;
        }

        /*
         * WARNING - void declaration
         */
        public void cancel() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VcsLogBigRepositoriesList vcsLogBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogBigRepositoriesList, (String)"getInstance(...)");
            VcsLogBigRepositoriesList bigRepositoriesList = vcsLogBigRepositoriesList;
            Iterable $this$forEach$iv = VcsLogStatusBarProgress.this.roots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                bigRepositoriesList.addRepository(it);
            }
            this.setText2(VcsLogBundle.message("vcs.log.status.bar.indexing.cancel.cancelling", new Object[0]));
            $this$forEach$iv = VcsLogStatusBarProgress.this.roots;
            Logger logger = LOG;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPresentableUrl());
            }
            logger.info("Indexing for " + (List)destination$iv$iv + " was cancelled from the status bar.");
            super.cancel();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyProgressListener;", "Lcom/intellij/vcs/log/data/VcsLogProgress$ProgressListener;", "(Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;)V", "progressChanged", "", "keys", "", "Lcom/intellij/vcs/log/data/VcsLogProgress$ProgressKey;", "progressStarted", "progressStopped", "intellij.platform.vcs.log.impl"})
    public final class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        @Override
        public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            if (VcsLogStatusBarProgress.this.disposableFlag.isDisposed()) {
                return;
            }
            if (CollectionsKt.contains((Iterable)keys, (Object)VcsLogPersistentIndex.INDEXING)) {
                VcsLogStatusBarProgress.this.start();
            }
        }

        @Override
        public void progressStopped() {
            if (VcsLogStatusBarProgress.this.disposableFlag.isDisposed()) {
                return;
            }
            VcsLogStatusBarProgress.this.stop();
        }

        @Override
        public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            if (VcsLogStatusBarProgress.this.disposableFlag.isDisposed()) {
                return;
            }
            if (CollectionsKt.contains((Iterable)keys, (Object)VcsLogPersistentIndex.INDEXING)) {
                VcsLogStatusBarProgress.this.start();
            } else {
                VcsLogStatusBarProgress.this.stop();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress$MyTaskInfo;", "Lcom/intellij/openapi/progress/TaskInfo;", "(Lcom/intellij/vcs/log/data/VcsLogStatusBarProgress;)V", "getCancelText", "", "getCancelTooltipText", "getStatusBarIndicatorWeight", "", "getTitle", "isCancellable", "", "intellij.platform.vcs.log.impl"})
    public final class MyTaskInfo
    implements TaskInfo {
        @NotNull
        public String getTitle() {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)VcsLogStatusBarProgress.this.vcsName)};
            String string2 = VcsLogBundle.message("vcs.log.status.bar.indexing", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }

        @NotNull
        public String getCancelText() {
            String string2 = CommonBundle.getCancelButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCancelButtonText(...)");
            return string2;
        }

        @NotNull
        public String getCancelTooltipText() {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)VcsLogStatusBarProgress.this.vcsName)};
            String string2 = VcsLogBundle.message("vcs.log.status.bar.indexing.cancel.tooltip", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }

        public boolean isCancellable() {
            return true;
        }

        public int getStatusBarIndicatorWeight() {
            return 1500;
        }
    }
}

