/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;

public final class VisitorDescription {
    private final Class<? extends DomElementVisitor> myVisitorClass;
    private final ClassMap<Method> myMethods = new ClassMap(new ConcurrentHashMap());
    @NonNls
    private static final String VISIT = "visit";

    public VisitorDescription(Class<? extends DomElementVisitor> visitorClass) {
        this.myVisitorClass = visitorClass;
        for (Method method : ReflectionUtil.getClassPublicMethods(visitorClass)) {
            String methodName;
            Class<?>[] parameterTypes;
            Class<?> domClass;
            if (method.getParameterCount() != 1 || !ReflectionUtil.isAssignable(DomElement.class, domClass = (parameterTypes = method.getParameterTypes())[0]) || !(methodName = method.getName()).startsWith(VISIT)) continue;
            method.setAccessible(true);
            this.myMethods.put(domClass, (Object)method);
        }
    }

    public void acceptElement(DomElementVisitor visitor, DomElement element) {
        Method method = (Method)this.myMethods.get(element.getClass());
        assert (method != null) : this.myVisitorClass + " can't accept element of type " + element.getClass();
        DomReflectionUtil.invokeMethod(method, visitor, element);
    }
}

