/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDomAnnotator
implements Annotator {
    public <T extends DomElement> void runInspection(@NotNull DomElementsInspection<DomElement> inspection, @NotNull DomFileElement<DomElement> fileElement, @NotNull AnnotationHolder toFill) {
        DomElementAnnotationsManagerImpl annotationsManager;
        if (inspection == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(0);
        }
        if (fileElement == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(1);
        }
        if (toFill == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(2);
        }
        if ((annotationsManager = this.getAnnotationsManager(fileElement.getFile().getProject())).isHolderUpToDate(fileElement) && annotationsManager.getProblemHolder(fileElement).isInspectionCompleted(inspection)) {
            return;
        }
        DomElementAnnotationHolderImpl annotationHolder = new DomElementAnnotationHolderImpl(true, fileElement, toFill);
        inspection.checkFileElement(fileElement, annotationHolder);
        List<DomElementProblemDescriptor> problemDescriptors = annotationsManager.appendProblems(fileElement, annotationHolder, ((Object)inspection).getClass());
        for (DomElementProblemDescriptor descriptor : problemDescriptors) {
            DomElementsHighlightingUtil.createProblemDescriptors(descriptor, s -> {
                AnnotationBuilder builder2 = toFill.newAnnotation(descriptor.getHighlightSeverity(), descriptor.getDescriptionTemplate()).range(((TextRange)s.first).shiftRight(((PsiElement)s.second).getTextOffset()));
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)ContainerUtil.getFirstItem(annotationsManager.createProblemDescriptors(InspectionManager.getInstance((Project)fileElement.getFile().getProject()), descriptor));
                LocalQuickFix[] fixes = descriptor.getFixes();
                if (problemDescriptor != null && fixes != null) {
                    for (LocalQuickFix fix : fixes) {
                        builder2 = builder2.newLocalQuickFix(fix, problemDescriptor).registerFix();
                    }
                }
                builder2.create();
                return null;
            });
        }
    }

    @NotNull
    protected DomElementAnnotationsManagerImpl getAnnotationsManager(@NotNull Project project2) {
        if (project2 == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(3);
        }
        DomElementAnnotationsManagerImpl domElementAnnotationsManagerImpl = (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance(project2);
        if (domElementAnnotationsManagerImpl == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(4);
        }
        return domElementAnnotationsManagerImpl;
    }

    public void annotate(@NotNull PsiElement psiElement, final @NotNull AnnotationHolder holder) {
        DomFileDescription<?> description2;
        if (psiElement == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(6);
        }
        if (!(psiElement instanceof XmlFile)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        final Project project2 = file.getProject();
        final DomManager domManager = DomManager.getDomManager(project2);
        DomFileDescription<?> domFileDescription = description2 = file instanceof XmlFile ? domManager.getDomFileDescription((XmlFile)file) : null;
        if (description2 != null) {
            psiElement.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                @Override
                public void visitXmlElement(@NotNull XmlElement element) {
                    DomElement domElement;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((domElement = DefaultDomAnnotator.getDomElement(element, domManager)) != null) {
                        DomFileElement<DomElement> root = DomUtil.getFileElement(domElement);
                        DomElementsInspection<DomElement> inspection = DefaultDomAnnotator.this.getAnnotationsManager(project2).getMockInspection(root);
                        if (inspection != null) {
                            DefaultDomAnnotator.this.runInspection(inspection, root, holder);
                        }
                    } else {
                        super.visitXmlElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/DefaultDomAnnotator$1", "visitXmlElement"));
                }
            });
        }
    }

    @Nullable
    private static DomElement getDomElement(@NotNull PsiElement psiElement, @NotNull DomManager myDomManager) {
        if (psiElement == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(7);
        }
        if (myDomManager == null) {
            DefaultDomAnnotator.$$$reportNull$$$0(8);
        }
        if (psiElement instanceof XmlTag) {
            return myDomManager.getDomElement((XmlTag)psiElement);
        }
        if (psiElement instanceof XmlAttribute) {
            return myDomManager.getDomElement((XmlAttribute)psiElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFill";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DefaultDomAnnotator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDomManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DefaultDomAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationsManager";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDomElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

