/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomGenerateProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    public static final String NAMESPACE_PREFIX_VAR = "NS_PREFIX";
    @Nullable
    private final String myMappingId;

    @Deprecated(forRemoval=true)
    public AbstractDomGenerateProvider(@Nls String description2, Class<T> aClass) {
        this(description2, aClass, null);
    }

    @Deprecated(forRemoval=true)
    public AbstractDomGenerateProvider(@Nls String description2, Class<T> aClass, @Nullable String mappingId) {
        this(description2, description2, aClass, mappingId);
    }

    public AbstractDomGenerateProvider(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description2, Class<T> aClass) {
        this(text2, description2, aClass, null);
    }

    public AbstractDomGenerateProvider(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description2, Class<T> aClass, @Nullable String mappingId) {
        super(text2, description2, aClass);
        this.myMappingId = mappingId;
    }

    @Override
    public T generate(Project project2, Editor editor, PsiFile file) {
        DomElement parentDomElement = this.getParentDomElement(project2, editor, file);
        Object t = this.generate(parentDomElement, editor);
        this.runTemplate(editor, file, t, this.getPredefinedVars(parentDomElement, t, editor, file));
        return t;
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable T t, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            AbstractDomGenerateProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AbstractDomGenerateProvider.$$$reportNull$$$0(1);
        }
        return AbstractDomGenerateProvider.createNamespacePrefixMap(parentDomElement);
    }

    @NotNull
    public static Map<String, String> createNamespacePrefixMap(@Nullable DomElement domElement) {
        HashMap<String, String> vars = new HashMap<String, String>();
        AbstractDomGenerateProvider.addNamespacePrefix(domElement, vars);
        HashMap<String, String> hashMap = vars;
        if (hashMap == null) {
            AbstractDomGenerateProvider.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    public static void addNamespacePrefix(@Nullable DomElement domElement, @NotNull Map<String, String> vars) {
        String namespacePrefix;
        XmlTag tag;
        if (vars == null) {
            AbstractDomGenerateProvider.$$$reportNull$$$0(3);
        }
        if (domElement != null && (tag = domElement.getXmlTag()) != null && !StringUtil.isEmptyOrSpaces((String)(namespacePrefix = tag.getNamespacePrefix()))) {
            vars.put(NAMESPACE_PREFIX_VAR, namespacePrefix + ":");
        }
    }

    protected void runTemplate(Editor editor, PsiFile file, T t, Map<String, String> predefinedVars) {
        DomTemplateRunner.getInstance(file.getProject()).runTemplate(t, this.myMappingId, editor, predefinedVars);
    }

    @Override
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Override
    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        DomElement element = this.getElementToNavigate(copy);
        if (element != null) {
            super.doNavigate(navigateProvider, element);
        }
    }

    @Nullable
    protected DomElement getElementToNavigate(T t) {
        return t;
    }

    protected static String getDescription(Class<? extends DomElement> aClass) {
        return StringUtil.join(Arrays.asList(NameUtilCore.nameToWords((String)aClass.getSimpleName())), (String)" ");
    }

    @Nullable
    public String getMappingId() {
        return this.myMappingId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/actions/generate/AbstractDomGenerateProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespacePrefixMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedVars";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addNamespacePrefix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

