/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlPanel
extends JEditorPane
implements HyperlinkListener {
    public HtmlPanel() {
        super("text/html", "");
        this.setEditable(false);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.addHyperlinkListener(new FilteringHyperlinkListener());
        this.setEditorKit(new HTMLEditorKitBuilder().withWordWrapViewFactory().build());
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    @Override
    public String getSelectedText() {
        Document doc2 = this.getDocument();
        int start2 = this.getSelectionStart();
        int end = this.getSelectionEnd();
        try {
            Position p0 = doc2.createPosition(start2);
            Position p1 = doc2.createPosition(end);
            StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
            this.getEditorKit().write(sw, doc2, p0.getOffset(), p1.getOffset() - p0.getOffset());
            return StringUtil.removeHtmlTags((String)sw.toString());
        }
        catch (IOException | BadLocationException exception) {
            return super.getSelectedText();
        }
    }

    public void setBody(@NotNull @Nls String text2) {
        if (text2 == null) {
            HtmlPanel.$$$reportNull$$$0(0);
        }
        if (text2.isEmpty()) {
            this.setText("");
        } else {
            @NlsSafe String cssFontDeclaration = UIUtil.getCssFontDeclaration((Font)this.getBodyFont());
            this.setText(new HtmlBuilder().append((HtmlChunk)HtmlChunk.raw((String)cssFontDeclaration).wrapWith("head")).append((HtmlChunk)HtmlChunk.raw((String)text2).wrapWith(HtmlChunk.body())).wrapWith(HtmlChunk.html()).toString());
        }
    }

    @NotNull
    protected Font getBodyFont() {
        Font font = FontUtil.getCommitMessageFont();
        if (font == null) {
            HtmlPanel.$$$reportNull$$$0(1);
        }
        return font;
    }

    @NotNull
    @Nls
    protected abstract String getBody();

    @Override
    public void updateUI() {
        super.updateUI();
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.update();
    }

    public void update() {
        this.setBody(this.getBody());
        this.customizeLinksStyle();
        this.revalidate();
        this.repaint();
    }

    private void customizeLinksStyle() {
        Document document2 = this.getDocument();
        if (document2 instanceof HTMLDocument) {
            StyleSheet styleSheet = ((HTMLDocument)document2).getStyleSheet();
            String linkColor = "#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
            styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/HtmlPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/HtmlPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setBody";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private final class FilteringHyperlinkListener
    implements HyperlinkListener {
        private FilteringHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.isToTheLeftOrAboveTheText(e.getInputEvent())) {
                return;
            }
            HtmlPanel.this.hyperlinkUpdate(e);
        }

        private boolean isToTheLeftOrAboveTheText(InputEvent event) {
            if (event instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                Insets insets = HtmlPanel.this.getInsets();
                if (insets == null) {
                    return false;
                }
                return mouseEvent.getX() < insets.left || mouseEvent.getY() < insets.top;
            }
            return false;
        }
    }
}

