/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFixFactory;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.KeyedLazyInstance;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellcheckingStrategy {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    public static final ExtensionPointName<KeyedLazyInstance<SpellcheckingStrategy>> EP_NAME = new ExtensionPointName("com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public String toString() {
            return "EMPTY_TOKENIZER";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());

    public Tokenizer getTokenizer(PsiElement element, Set<SpellCheckingInspection.SpellCheckingScope> scope2) {
        return this.getTokenizer(element);
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (SpellcheckingStrategy.isInjectedLanguageFragment(element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = PsiIdentifierOwnerTokenizer.INSTANCE;
            if (psiIdentifierOwnerTokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return psiIdentifierOwnerTokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(3);
                }
                return tokenizer;
            }
            if (element.getTextOffset() == 0 && element.getText().startsWith("#!")) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(4);
                }
                return tokenizer;
            }
            Tokenizer<PsiComment> tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return tokenizer;
        }
        if (element instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file = element.getContainingFile();
            FileType fileType2 = fileType = file == null ? null : file.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                return new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            }
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(6);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(7);
        }
        return tokenizer;
    }

    public boolean elementFitsScope(@NotNull PsiElement element, Set<SpellCheckingInspection.SpellCheckingScope> scope2) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(8);
        }
        Language language = element.getLanguage();
        IElementType elementType = element.getNode().getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return parserDefinition == null || !(parserDefinition.getStringLiteralElements().contains(elementType) ? !scope2.contains((Object)SpellCheckingInspection.SpellCheckingScope.Literals) : (parserDefinition.getCommentTokens().contains(elementType) ? !scope2.contains((Object)SpellCheckingInspection.SpellCheckingScope.Comments) : !scope2.contains((Object)SpellCheckingInspection.SpellCheckingScope.Code)));
    }

    protected static boolean isInjectedLanguageFragment(@Nullable PsiElement element) {
        return element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element));
    }

    public LocalQuickFix[] getRegularFixes(@NotNull PsiElement element, @NotNull TextRange textRange, boolean useRename, String typo) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(10);
        }
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, typo, element, textRange);
    }

    public static LocalQuickFix[] getDefaultRegularFixes(boolean useRename, String typo, @NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(11);
        }
        if (range == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(12);
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        if (useRename && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiNamedElement.class}) != null) {
            result2.add(SpellCheckerQuickFixFactory.rename(element));
        } else {
            result2.addAll(SpellCheckerQuickFixFactory.changeToVariants(element, range, typo));
        }
        SpellCheckerSettings settings = SpellCheckerSettings.getInstance(element.getProject());
        if (settings.isUseSingleDictionaryToSave()) {
            DictionaryLayer layer = DictionaryLayersProvider.getLayer(element.getProject(), settings.getDictionaryToSave());
            result2.add(SpellCheckerQuickFixFactory.saveTo(element, range, typo, layer));
            return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        result2.add(SpellCheckerQuickFixFactory.saveTo(element, range, typo));
        return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static LocalQuickFix[] getDefaultBatchFixes(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull String word) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(13);
        }
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(14);
        }
        if (word == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(15);
        }
        return (LocalQuickFix[])DictionaryLayersProvider.getAllLayers(element.getProject()).stream().map(it -> SpellCheckerQuickFixFactory.saveTo(element, textRange, word, it)).toArray(LocalQuickFix[]::new);
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(16);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "elementFitsScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRegularFixes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRegularFixes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBatchFixes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string2);
        };
    }
}

