/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpellCheckingInspection
extends LocalInspectionTool {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element != null && (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language = element.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            SuppressQuickFix[] suppressQuickFixArray = ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element, this.getShortName());
            if (suppressQuickFixArray == null) {
                SpellCheckingInspection.$$$reportNull$$$0(0);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element);
        if (suppressQuickFixArray == null) {
            SpellCheckingInspection.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    private static SpellcheckingStrategy getSpellcheckingStrategy(@NotNull PsiElement element, @NotNull Language language) {
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(2);
        }
        if (language == null) {
            SpellCheckingInspection.$$$reportNull$$$0(3);
        }
        for (SpellcheckingStrategy strategy : LanguageSpellchecking.INSTANCE.allForLanguage(language)) {
            if (!strategy.isMyContext(element)) continue;
            return strategy;
        }
        return null;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(4);
        }
        if ((strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language = element.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element, this.getShortName());
        }
        return super.isSuppressedFor(element);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(5);
        }
        if (!Registry.is((String)"spellchecker.inspection.enabled", (boolean)true)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpellCheckingInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        final SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        final Set<SpellCheckingScope> scope2 = this.buildAllowedScopes();
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (holder.getResultCount() > 1000) {
                    return;
                }
                ASTNode node = element.getNode();
                if (node == null) {
                    return;
                }
                Language language = element.getLanguage();
                SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language);
                if (strategy == null) {
                    return;
                }
                if (!strategy.elementFitsScope(element, scope2)) {
                    return;
                }
                PsiFile containingFile = holder.getFile();
                if (Boolean.TRUE.equals(containingFile.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION))) {
                    return;
                }
                SpellCheckingInspection.tokenize(element, language, (TokenConsumer)new MyTokenConsumer(manager, holder, LanguageNamesValidation.INSTANCE.forLanguage(language)), (Set<SpellCheckingScope>)scope2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection$1", "visitElement"));
            }
        };
    }

    private Set<SpellCheckingScope> buildAllowedScopes() {
        HashSet<SpellCheckingScope> result2 = new HashSet<SpellCheckingScope>();
        if (this.processLiterals) {
            result2.add(SpellCheckingScope.Literals);
        }
        if (this.processComments) {
            result2.add(SpellCheckingScope.Comments);
        }
        if (this.processCode) {
            result2.add(SpellCheckingScope.Code);
        }
        return result2;
    }

    public static void tokenize(@NotNull PsiElement element, @NotNull Language language, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        SpellcheckingStrategy factoryByLanguage;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(7);
        }
        if (language == null) {
            SpellCheckingInspection.$$$reportNull$$$0(8);
        }
        if ((factoryByLanguage = SpellCheckingInspection.getSpellcheckingStrategy(element, language)) == null) {
            return;
        }
        SpellCheckingInspection.tokenize(factoryByLanguage, element, consumer, allowedScopes);
    }

    private static void tokenize(SpellcheckingStrategy strategy, PsiElement element, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        Tokenizer tokenizer = strategy.getTokenizer(element, allowedScopes);
        tokenizer.tokenize(element, consumer);
    }

    private static void addBatchDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull String word, @NotNull ProblemsHolder holder) {
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(10);
        }
        if (word == null) {
            SpellCheckingInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(12);
        }
        LocalQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes(element, textRange, word);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        SpellcheckingStrategy strategy;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(13);
        }
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(15);
        }
        LocalQuickFix[] fixes = (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, element.getLanguage())) != null ? strategy.getRegularFixes(element, textRange, useRename, wordWithTypo) : SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo, element, textRange);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element, TextRange textRange, LocalQuickFix[] fixes, boolean onTheFly) {
        String description2 = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        return new ProblemDescriptorBase(element, element, description2, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, textRange, onTheFly, onTheFly);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"processCode", (String)SpellCheckerBundle.message("process.code", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processLiterals", (String)SpellCheckerBundle.message("process.literals", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processComments", (String)SpellCheckerBundle.message("process.comments", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SpellCheckingInspection.$$$reportNull$$$0(16);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpellcheckingStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBatchDescriptor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRegularDescriptor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string2);
        };
    }

    public static enum SpellCheckingScope {
        Comments,
        Literals,
        Code;

    }

    private static final class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private final Set<String> myAlreadyChecked = CollectionFactory.createSmallMemoryFootprintSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        MyTokenConsumer(SpellCheckerManager manager, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        @Override
        public void consumeToken(PsiElement element, String text2, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element;
            this.myText = text2;
            this.myUseRename = useRename;
            this.myOffset = offset;
            splitter.split(text2, rangeToCheck, this);
        }

        public void consume(TextRange range) {
            ProgressManager.checkCanceled();
            String word = range.substring(this.myText);
            if (!this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword) {
                return;
            }
            if (this.myManager.hasProblem(word)) {
                Tokenizer tokenizer;
                SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(this.myElement, this.myElement.getLanguage());
                Tokenizer tokenizer2 = tokenizer = strategy != null ? strategy.getTokenizer(this.myElement) : null;
                if (tokenizer != null) {
                    range = tokenizer.getHighlightingRange(this.myElement, this.myOffset, range);
                }
                assert (range.getStartOffset() >= 0);
                if (this.myHolder.isOnTheFly()) {
                    SpellCheckingInspection.addRegularDescriptor(this.myElement, range, this.myHolder, this.myUseRename, word);
                } else {
                    this.myAlreadyChecked.add(word);
                    SpellCheckingInspection.addBatchDescriptor(this.myElement, range, word, this.myHolder);
                }
            }
        }
    }
}

