/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smartUpdate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.smartUpdate.IdeUpdateStepKt;
import com.intellij.smartUpdate.SmartUpdate;
import com.intellij.smartUpdate.SmartUpdateBundle;
import com.intellij.smartUpdate.SmartUpdateDialogKt;
import com.intellij.smartUpdate.StepOption;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.ToolboxUpdateAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u0004H\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/smartUpdate/IdeUpdateStep;", "Lcom/intellij/smartUpdate/StepOption;", "()V", "groupName", "", "getGroupName", "()Ljava/lang/String;", "id", "getId", "optionName", "getOptionName", "stepName", "getStepName", "getDescription", "getDetailsComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "performUpdateStep", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onSuccess", "Lkotlin/Function0;", "intellij.smart.update"})
@SourceDebugExtension(value={"SMAP\nIdeUpdateStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeUpdateStep.kt\ncom/intellij/smartUpdate/IdeUpdateStep\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n31#2,2:88\n*S KotlinDebug\n*F\n+ 1 IdeUpdateStep.kt\ncom/intellij/smartUpdate/IdeUpdateStep\n*L\n35#1:88,2\n*E\n"})
public final class IdeUpdateStep
implements StepOption {
    @NotNull
    private final String id;
    @NotNull
    private final String stepName = SmartUpdateBundle.INSTANCE.message("checkbox.update.ide", new Object[0]);
    @NotNull
    private final String optionName = SmartUpdateBundle.INSTANCE.message("update.ide.option.toolbox", new Object[0]);
    @NotNull
    private final String groupName = SmartUpdateBundle.INSTANCE.message("update.ide.group", new Object[0]);

    public IdeUpdateStep() {
        this.id = "ide.update";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getStepName() {
        return this.stepName;
    }

    @Override
    @NotNull
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    @NotNull
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void performUpdateStep(@NotNull Project project2, @Nullable AnActionEvent e, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        ToolboxUpdateAction updateAction = IdeUpdateStepKt.access$getUpdateAction();
        IdeUpdateStepKt.access$getLOG$p().info("Update action: " + updateAction);
        if (updateAction != null) {
            updateAction.perform();
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<SmartUpdate> serviceClass$iv = SmartUpdate.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((SmartUpdate)object).setRestartRequested(true);
        } else {
            onSuccess2.invoke();
        }
    }

    @Override
    @NotNull
    public JComponent getDetailsComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (JComponent)SmartUpdateDialogKt.hintLabel(this.getDescription());
    }

    @Nls
    private final String getDescription() {
        ToolboxUpdateAction updateAction = IdeUpdateStepKt.access$getUpdateAction();
        if (updateAction == null) {
            return SmartUpdateBundle.INSTANCE.message("no.updates.available", new Object[0]);
        }
        String string2 = updateAction.getTemplatePresentation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return string2;
    }
}

