/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface ActionInfo {
    public static final ActionInfo UPDATE = new ActionInfo(){

        @Override
        public boolean showOptions(Project project2) {
            return ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.UPDATE).getValue();
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getUpdateEnvironment();
        }

        @Override
        public String getActionName() {
            return VcsBundle.message("action.name.update", new Object[0]);
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(final Project project2, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, String scopeName) {
            return new UpdateOrStatusOptionsDialog(project2, VcsBundle.message("action.display.name.update.scope", scopeName), envToConfMap){

                @Override
                @NlsSafe
                protected String getActionNameForDimensions() {
                    return "update-v2";
                }

                @NotNull
                protected String getDoNotShowMessage() {
                    String string2 = VcsBundle.message("update.checkbox.don.t.show.again", new Object[0]);
                    if (string2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                protected boolean isToBeShown() {
                    return ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.UPDATE).getValue();
                }

                protected void setToBeShown(boolean value2, boolean onOk) {
                    if (onOk) {
                        ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.UPDATE).setValue(value2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ActionInfo$1$1", "getDoNotShowMessage"));
                }
            };
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message("action.name.update.scope", scopeName);
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getUpdateName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return true;
        }

        @Override
        public boolean canChangeFileStatus() {
            return false;
        }
    };
    public static final ActionInfo STATUS = new ActionInfo(){

        @Override
        public boolean showOptions(Project project2) {
            return ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.STATUS).getValue();
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getStatusEnvironment();
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(final Project project2, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, String scopeName) {
            return new UpdateOrStatusOptionsDialog(project2, VcsBundle.message("action.display.name.check.scope.status", scopeName), envToConfMap){

                @Override
                protected String getActionNameForDimensions() {
                    return "status";
                }

                protected boolean isToBeShown() {
                    return ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.STATUS).getValue();
                }

                protected void setToBeShown(boolean value2, boolean onOk) {
                    if (onOk) {
                        ProjectLevelVcsManagerEx.getInstanceEx(project2).getOptions(VcsConfiguration.StandardOption.STATUS).setValue(value2);
                    }
                }
            };
        }

        @Override
        public String getActionName() {
            return VcsBundle.message("action.name.check.status", new Object[0]);
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message("action.name.check.scope.status", scopeName);
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getStatusName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return false;
        }

        @Override
        public boolean canChangeFileStatus() {
            return true;
        }
    };
    public static final ActionInfo INTEGRATE = new ActionInfo(){

        @Override
        public boolean showOptions(Project project2) {
            return true;
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getIntegrateEnvironment();
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(Project project2, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, String scopeName) {
            return new UpdateOrStatusOptionsDialog(project2, VcsBundle.message("action.display.name.integrate.scope", scopeName), envToConfMap){

                @Override
                @NlsSafe
                protected String getActionNameForDimensions() {
                    return "integrate";
                }

                protected boolean canBeHidden() {
                    return false;
                }

                protected boolean isToBeShown() {
                    return true;
                }

                protected void setToBeShown(boolean value2, boolean onOk) {
                }
            };
        }

        @Override
        public boolean canChangeFileStatus() {
            return true;
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message("action.name.integrate.scope", scopeName);
        }

        @Override
        public String getActionName() {
            return VcsBundle.message("action.name.integrate", new Object[0]);
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getUpdateName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return false;
        }
    };

    public boolean showOptions(Project var1);

    public UpdateEnvironment getEnvironment(AbstractVcs var1);

    public UpdateOrStatusOptionsDialog createOptionsDialog(Project var1, LinkedHashMap<Configurable, AbstractVcs> var2, String var3);

    @NlsActions.ActionText
    public String getActionName(String var1);

    public String getActionName();

    @Nls
    public String getGroupName(FileGroup var1);

    public boolean canGroupByChangelist();

    public boolean canChangeFileStatus();
}

