/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.WaitForProgressToShow;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsHistoryUtil {
    private static final Logger LOG = Logger.getInstance(VcsHistoryUtil.class);

    private VcsHistoryUtil() {
    }

    public static int compare(VcsFileRevision first, VcsFileRevision second) {
        if (first instanceof CurrentRevision && second instanceof CurrentRevision) {
            return VcsHistoryUtil.compareNumbers(first, second);
        }
        if (second instanceof CurrentRevision) {
            return -1 * VcsHistoryUtil.compare(second, first);
        }
        if (first instanceof CurrentRevision) {
            int result2 = VcsHistoryUtil.compareNumbers(first, second);
            if (result2 == 0) {
                return 1;
            }
            return result2;
        }
        return VcsHistoryUtil.compareNumbers(first, second);
    }

    public static int compareNumbers(VcsFileRevision first, VcsFileRevision second) {
        return first.getRevisionNumber().compareTo(second.getRevisionNumber());
    }

    public static void showDiff(@NotNull Project project2, @NotNull FilePath path2, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, @NotNull @NlsContexts.Label String title1, @NotNull @NlsContexts.Label String title2) throws VcsException, IOException {
        if (project2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(1);
        }
        if (revision1 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(2);
        }
        if (revision2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(3);
        }
        if (title1 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(5);
        }
        FilePath path1 = VcsHistoryUtil.getRevisionPath(revision1);
        FilePath path22 = VcsHistoryUtil.getRevisionPath(revision2);
        String title3 = path1 != null && path22 != null ? DiffRequestFactoryImpl.getTitle((FilePath)path1, (FilePath)path22, (String)" -> ") : DiffRequestFactoryImpl.getContentTitle((FilePath)path2);
        DiffContent diffContent1 = VcsHistoryUtil.loadContentForDiff(project2, path2, revision1);
        DiffContent diffContent2 = VcsHistoryUtil.loadContentForDiff(project2, path2, revision2);
        SimpleDiffRequest request = new SimpleDiffRequest(title3, diffContent1, diffContent2, title1, title2);
        diffContent1.putUserData(DiffVcsDataKeys.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision1));
        diffContent2.putUserData(DiffVcsDataKeys.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision2));
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> VcsHistoryUtil.lambda$showDiff$0(project2, (DiffRequest)request), null, (Project)project2);
    }

    @NotNull
    public static DiffContent loadContentForDiff(@NotNull Project project2, @NotNull FilePath path2, @NotNull VcsFileRevision revision) throws IOException, VcsException {
        if (project2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(7);
        }
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(8);
        }
        return VcsHistoryUtil.createContent(project2, VcsHistoryUtil.loadRevisionContent(revision), revision, path2);
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getRevisionInfo(@NotNull VcsFileRevision revision) {
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(9);
        }
        if (revision instanceof VcsFileRevisionEx) {
            return Pair.create((Object)((VcsFileRevisionEx)revision).getPath(), (Object)revision.getRevisionNumber());
        }
        return null;
    }

    @Nullable
    private static FilePath getRevisionPath(@NotNull VcsFileRevision revision) {
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(10);
        }
        if (revision instanceof VcsFileRevisionEx) {
            return ((VcsFileRevisionEx)revision).getPath();
        }
        return null;
    }

    public static byte @NotNull [] loadRevisionContent(@NotNull VcsFileRevision revision) throws VcsException, IOException {
        byte[] content;
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(11);
        }
        if ((content = revision.loadContent()) == null) {
            throw new VcsException(VcsBundle.message("history.failed.to.load.content.for.revision.0", revision.getRevisionNumber().asString()));
        }
        if (content == null) {
            VcsHistoryUtil.$$$reportNull$$$0(12);
        }
        return content;
    }

    public static String loadRevisionContentGuessEncoding(@NotNull VcsFileRevision revision, @Nullable VirtualFile file, @Nullable Project project2) throws VcsException, IOException {
        EncodingProjectManager e;
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(13);
        }
        byte[] bytes = VcsHistoryUtil.loadRevisionContent(revision);
        if (file != null) {
            return new String(bytes, file.getCharset());
        }
        EncodingProjectManager encodingProjectManager = e = project2 != null ? EncodingProjectManager.getInstance((Project)project2) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)e.getDefaultCharset());
    }

    @NotNull
    private static DiffContent createContent(@NotNull Project project2, byte @NotNull [] content, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) throws IOException {
        VirtualFile file;
        if (project2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(14);
        }
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(15);
        }
        if (filePath == null) {
            VcsHistoryUtil.$$$reportNull$$$0(16);
        }
        if (content == null) {
            VcsHistoryUtil.$$$reportNull$$$0(17);
        }
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (VcsHistoryUtil.isCurrent(revision) && (file = filePath.getVirtualFile()) != null) {
            DiffContent diffContent = contentFactory.create(project2, file);
            if (diffContent == null) {
                VcsHistoryUtil.$$$reportNull$$$0(18);
            }
            return diffContent;
        }
        if (VcsHistoryUtil.isEmpty(revision)) {
            EmptyContent emptyContent = contentFactory.createEmpty();
            if (emptyContent == null) {
                VcsHistoryUtil.$$$reportNull$$$0(19);
            }
            return emptyContent;
        }
        DiffContent diffContent = contentFactory.createFromBytes(project2, content, filePath, revision.getDefaultCharset());
        if (diffContent == null) {
            VcsHistoryUtil.$$$reportNull$$$0(20);
        }
        return diffContent;
    }

    private static boolean isCurrent(VcsFileRevision revision) {
        return revision instanceof CurrentRevision;
    }

    public static boolean isEmpty(VcsFileRevision revision) {
        return revision == null || VcsFileRevision.NULL.equals(revision);
    }

    public static void showDifferencesInBackground(final @NotNull Project project2, final @NotNull FilePath filePath, final @NotNull VcsFileRevision older, final @NotNull VcsFileRevision newer) {
        if (project2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(21);
        }
        if (filePath == null) {
            VcsHistoryUtil.$$$reportNull$$$0(22);
        }
        if (older == null) {
            VcsHistoryUtil.$$$reportNull$$$0(23);
        }
        if (newer == null) {
            VcsHistoryUtil.$$$reportNull$$$0(24);
        }
        new Task.Backgroundable(project2, VcsBundle.message("file.history.diff.revisions.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    VcsHistoryUtil.showDiff(project2, filePath, older, newer, 1.makeTitle(older), 1.makeTitle(newer));
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((String)VcsBundle.message("message.text.cannot.show.differences", e.getLocalizedMessage()), (String)VcsBundle.message("message.title.show.differences", new Object[0])), null, (Project)project2);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }

            @NotNull
            @NlsContexts.Label
            private static String makeTitle(@NotNull VcsFileRevision revision) {
                if (revision == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string2 = revision.getRevisionNumber().asString() + (String)(revision instanceof CurrentRevision ? " (" + VcsBundle.message("diff.title.local", new Object[0]) + ")" : "");
                if (string2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "revision";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/history/VcsHistoryUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "makeTitle";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        }.queue();
    }

    private static /* synthetic */ void lambda$showDiff$0(Project project2, DiffRequest request) {
        DiffManager.getInstance().showDiff(project2, request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title2";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsHistoryUtil";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "older";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisionContent";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadContentForDiff";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionContent";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionContentGuessEncoding";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showDifferencesInBackground";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 18, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

