/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.HistoryCacheBaseKey;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.Serializable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ \u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJG\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0018*\u00020\u0019\"\b\b\u0001\u0010\u0017*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\nJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JM\u0010#\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0018*\u00020\u0019\"\b\b\u0001\u0010\u0017*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001c2\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010&J_\u0010'\u001a\u00020\f\"\b\b\u0000\u0010\u0018*\u00020\u0019\"\b\b\u0001\u0010\u0017*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u0002H\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001c2\u0006\u0010*\u001a\u00020%H\u0007\u00a2\u0006\u0002\u0010+J&\u0010,\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0001J&\u0010.\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJ]\u00100\u001a\u00020\f\"\b\b\u0000\u0010\u0018*\u00020\u0019\"\b\b\u0001\u0010\u0017*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u0002H\u00172\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001c2\u0006\u0010*\u001a\u00020%\u00a2\u0006\u0002\u0010+R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/openapi/vcs/history/VcsHistoryCache;", "", "()V", "annotationCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/openapi/vcs/history/HistoryCacheWithRevisionKey;", "historyCache", "Lcom/intellij/openapi/vcs/history/HistoryCacheBaseKey;", "Lcom/intellij/openapi/vcs/history/VcsHistoryCache$CachedHistory;", "lastRevisionCache", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "clearAll", "", "clearAnnotations", "clearHistory", "clearLastRevisions", "getAnnotation", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "vcsKey", "Lcom/intellij/openapi/vcs/VcsKey;", "number", "getFull", "T", "C", "Ljava/io/Serializable;", "Lcom/intellij/openapi/vcs/history/VcsAbstractHistorySession;", "factory", "Lcom/intellij/openapi/vcs/history/VcsCacheableHistorySessionFactory;", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/VcsKey;Lcom/intellij/openapi/vcs/history/VcsCacheableHistorySessionFactory;)Lcom/intellij/openapi/vcs/history/VcsAbstractHistorySession;", "getLastRevision", "currentRevision", "getRevisions", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "getSession", "allowPartial", "", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/VcsKey;Lcom/intellij/openapi/vcs/history/VcsCacheableHistorySessionFactory;Z)Lcom/intellij/openapi/vcs/history/VcsAbstractHistorySession;", "put", "correctedPath", "session", "isFull", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/VcsKey;Lcom/intellij/openapi/vcs/history/VcsAbstractHistorySession;Lcom/intellij/openapi/vcs/history/VcsCacheableHistorySessionFactory;Z)V", "putAnnotation", "vcsAnnotation", "putLastRevision", "lastRevision", "putSession", "CachedHistory", "intellij.platform.vcs"})
@SourceDebugExtension(value={"SMAP\nVcsHistoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsHistoryCache.kt\ncom/intellij/openapi/vcs/history/VcsHistoryCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class VcsHistoryCache {
    @NotNull
    private final Cache<HistoryCacheBaseKey, CachedHistory> historyCache;
    @NotNull
    private final Cache<HistoryCacheWithRevisionKey, Object> annotationCache;
    @NotNull
    private final Cache<HistoryCacheWithRevisionKey, VcsRevisionNumber> lastRevisionCache;

    public VcsHistoryCache() {
        boolean preloadEnabled = AdvancedSettings.Companion.getBoolean("vcs.annotations.preload") || Registry.is((String)"vcs.code.author.inlay.hints");
        Cache cache = Caffeine.newBuilder().maximumSize((long)(preloadEnabled ? 50 : 10)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.historyCache = cache;
        Cache cache2 = Caffeine.newBuilder().maximumSize((long)(preloadEnabled ? 50 : 10)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.annotationCache = cache2;
        Cache cache3 = Caffeine.newBuilder().maximumSize(50L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.lastRevisionCache = cache3;
    }

    public final <C extends Serializable, T extends VcsAbstractHistorySession> void putSession(@NotNull FilePath filePath, @Nullable FilePath correctedPath, @NotNull VcsKey vcsKey, @NotNull T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        FilePath filePath2 = correctedPath;
        if (filePath2 == null) {
            filePath2 = filePath;
        }
        List<VcsFileRevision> list2 = session.getRevisionList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRevisionList(...)");
        CachedHistory cachedHistory = new CachedHistory(filePath2, list2, session.getCurrentRevisionNumber(), factory.getAdditionallyCachedData(session), isFull);
        this.historyCache.put((Object)new HistoryCacheBaseKey(filePath, vcsKey), (Object)cachedHistory);
    }

    @Deprecated(message="Use putSession instead", replaceWith=@ReplaceWith(expression="putSession(filePath, correctedPath, vcsKey, session, factory, isFull)", imports={}))
    public final <C extends Serializable, T extends VcsAbstractHistorySession> void put(@NotNull FilePath filePath, @Nullable FilePath correctedPath, @NotNull VcsKey vcsKey, @NotNull T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.putSession(filePath, correctedPath, vcsKey, session, factory, isFull);
    }

    @Nullable
    public final <C extends Serializable, T extends VcsAbstractHistorySession> T getSession(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean allowPartial) {
        CachedHistory cachedHistory;
        block3: {
            block2: {
                CachedHistory cachedHistory2;
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                cachedHistory = (CachedHistory)this.historyCache.getIfPresent((Object)new HistoryCacheBaseKey(filePath, vcsKey));
                if (cachedHistory == null) break block2;
                CachedHistory it = cachedHistory2 = cachedHistory;
                boolean bl = false;
                cachedHistory = it.isFull() || allowPartial ? cachedHistory2 : null;
                if (cachedHistory != null) break block3;
            }
            return null;
        }
        CachedHistory cachedHistory3 = cachedHistory;
        Serializable customData = (Serializable)cachedHistory3.getCustomData();
        return factory.createFromCachedData(customData, cachedHistory3.getRevisions(), cachedHistory3.getPath(), cachedHistory3.getCurrentRevision());
    }

    @Deprecated(message="Use getSession instead", replaceWith=@ReplaceWith(expression="getSession(filePath, vcsKey, factory, false)", imports={}))
    @Nullable
    public final <C extends Serializable, T extends VcsAbstractHistorySession> T getFull(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        return this.getSession(filePath, vcsKey, factory, false);
    }

    @NotNull
    public final List<VcsFileRevision> getRevisions(@NotNull FilePath filePath, @NotNull VcsKey vcsKey) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        CachedHistory cachedHistory = (CachedHistory)this.historyCache.getIfPresent((Object)new HistoryCacheBaseKey(filePath, vcsKey));
        if (cachedHistory == null) {
            return CollectionsKt.emptyList();
        }
        return cachedHistory.getRevisions();
    }

    public final void clearHistory() {
        this.historyCache.asMap().keySet().removeIf(arg_0 -> VcsHistoryCache.clearHistory$lambda$1(clearHistory.1.INSTANCE, arg_0));
    }

    public final void putAnnotation(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number, @NotNull Object vcsAnnotation) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)vcsAnnotation, (String)"vcsAnnotation");
        this.annotationCache.put((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, number), vcsAnnotation);
    }

    @Nullable
    public final Object getAnnotation(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return this.annotationCache.getIfPresent((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, number));
    }

    public final void clearAnnotations() {
        this.annotationCache.invalidateAll();
    }

    public final void putLastRevision(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber currentRevision, @NotNull VcsRevisionNumber lastRevision) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter((Object)currentRevision, (String)"currentRevision");
        Intrinsics.checkNotNullParameter((Object)lastRevision, (String)"lastRevision");
        this.lastRevisionCache.put((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, currentRevision), (Object)lastRevision);
    }

    @Nullable
    public final VcsRevisionNumber getLastRevision(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber currentRevision) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
        Intrinsics.checkNotNullParameter((Object)currentRevision, (String)"currentRevision");
        return (VcsRevisionNumber)this.lastRevisionCache.getIfPresent((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, currentRevision));
    }

    public final void clearLastRevisions() {
        this.lastRevisionCache.invalidateAll();
    }

    public final void clearAll() {
        this.clearHistory();
        this.clearAnnotations();
        this.clearLastRevisions();
    }

    private static final boolean clearHistory$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/history/VcsHistoryCache$CachedHistory;", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revisions", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "currentRevision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "customData", "isFull", "", "(Lcom/intellij/openapi/vcs/FilePath;Ljava/util/List;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/lang/Object;Z)V", "getCurrentRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getCustomData", "()Ljava/lang/Object;", "()Z", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRevisions", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.vcs"})
    private static final class CachedHistory {
        @NotNull
        private final FilePath path;
        @NotNull
        private final List<VcsFileRevision> revisions;
        @Nullable
        private final VcsRevisionNumber currentRevision;
        @Nullable
        private final Object customData;
        private final boolean isFull;

        public CachedHistory(@NotNull FilePath path2, @NotNull List<? extends VcsFileRevision> revisions, @Nullable VcsRevisionNumber currentRevision, @Nullable Object customData, boolean isFull) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
            this.path = path2;
            this.revisions = revisions;
            this.currentRevision = currentRevision;
            this.customData = customData;
            this.isFull = isFull;
        }

        @NotNull
        public final FilePath getPath() {
            return this.path;
        }

        @NotNull
        public final List<VcsFileRevision> getRevisions() {
            return this.revisions;
        }

        @Nullable
        public final VcsRevisionNumber getCurrentRevision() {
            return this.currentRevision;
        }

        @Nullable
        public final Object getCustomData() {
            return this.customData;
        }

        public final boolean isFull() {
            return this.isFull;
        }

        @NotNull
        public final FilePath component1() {
            return this.path;
        }

        @NotNull
        public final List<VcsFileRevision> component2() {
            return this.revisions;
        }

        @Nullable
        public final VcsRevisionNumber component3() {
            return this.currentRevision;
        }

        @Nullable
        public final Object component4() {
            return this.customData;
        }

        public final boolean component5() {
            return this.isFull;
        }

        @NotNull
        public final CachedHistory copy(@NotNull FilePath path2, @NotNull List<? extends VcsFileRevision> revisions, @Nullable VcsRevisionNumber currentRevision, @Nullable Object customData, boolean isFull) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
            return new CachedHistory(path2, revisions, currentRevision, customData, isFull);
        }

        public static /* synthetic */ CachedHistory copy$default(CachedHistory cachedHistory, FilePath filePath, List list2, VcsRevisionNumber vcsRevisionNumber, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                filePath = cachedHistory.path;
            }
            if ((n & 2) != 0) {
                list2 = cachedHistory.revisions;
            }
            if ((n & 4) != 0) {
                vcsRevisionNumber = cachedHistory.currentRevision;
            }
            if ((n & 8) != 0) {
                object = cachedHistory.customData;
            }
            if ((n & 0x10) != 0) {
                bl = cachedHistory.isFull;
            }
            return cachedHistory.copy(filePath, list2, vcsRevisionNumber, object, bl);
        }

        @NotNull
        public String toString() {
            return "CachedHistory(path=" + this.path + ", revisions=" + this.revisions + ", currentRevision=" + this.currentRevision + ", customData=" + this.customData + ", isFull=" + this.isFull + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + ((Object)this.revisions).hashCode();
            result2 = result2 * 31 + (this.currentRevision == null ? 0 : this.currentRevision.hashCode());
            result2 = result2 * 31 + (this.customData == null ? 0 : this.customData.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isFull);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedHistory)) {
                return false;
            }
            CachedHistory cachedHistory = (CachedHistory)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)cachedHistory.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.revisions, cachedHistory.revisions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentRevision, (Object)cachedHistory.currentRevision)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.customData, (Object)cachedHistory.customData)) {
                return false;
            }
            return this.isFull == cachedHistory.isFull;
        }
    }
}

