/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestoreShelvedChange
extends DumbAwareAction {
    public RestoreShelvedChange() {
        super(ActionsBundle.messagePointer((String)"action.RestoreShelvedChange.text", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreShelvedChange.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation2 = e.getPresentation();
        if (project2 == null || project2.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        List deletedLists = ContainerUtil.notNullize((List)((List)e.getData(ShelvedChangesViewManager.SHELVED_DELETED_CHANGELIST_KEY)));
        presentation2.setText(VcsBundle.messagePointer("vcs.shelf.action.restore.text", new Object[0]));
        presentation2.setDescription(VcsBundle.messagePointer("vcs.shelf.action.restore.description", deletedLists.size()));
        presentation2.setEnabled(!ContainerUtil.isEmpty((Collection)deletedLists));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RestoreShelvedChange.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RestoreShelvedChange.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        List lists = (List)e.getData(ShelvedChangesViewManager.SHELVED_DELETED_CHANGELIST_KEY);
        if (lists == null || lists.isEmpty()) {
            return;
        }
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        Date currentDate = new Date(System.currentTimeMillis());
        lists.forEach(l -> shelveChangesManager.restoreList((ShelvedChangeList)l, currentDate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/RestoreShelvedChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/RestoreShelvedChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

