/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ColumnFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.changes.committed.NoneChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.StructureFilteringStrategy;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectFilteringAction
extends LabeledComboBoxAction
implements DumbAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;
    @NotNull
    private ChangeListFilteringStrategy myPreviousSelection;

    public SelectFilteringAction(@NotNull Project project2, @NotNull CommittedChangesTreeBrowser browser) {
        if (project2 == null) {
            SelectFilteringAction.$$$reportNull$$$0(0);
        }
        if (browser == null) {
            SelectFilteringAction.$$$reportNull$$$0(1);
        }
        super(VcsBundle.message("committed.changes.filter.title", new Object[0]));
        this.myPreviousSelection = NoneChangeListFilteringStrategy.INSTANCE;
        this.myProject = project2;
        this.myBrowser = browser;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SelectFilteringAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectFilteringAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setText(this.myPreviousSelection.toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        if (button == null) {
            SelectFilteringAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SelectFilteringAction.$$$reportNull$$$0(5);
        }
        return new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetFilteringAction((ChangeListFilteringStrategy)strategy))));
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        Condition condition = action2 -> ((SetFilteringAction)action2).myStrategy.getKey().equals(this.myPreviousSelection.getKey());
        if (condition == null) {
            SelectFilteringAction.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @NotNull
    private List<ChangeListFilteringStrategy> collectStrategies() {
        ArrayList<ChangeListFilteringStrategy> result2 = new ArrayList<ChangeListFilteringStrategy>();
        result2.add(NoneChangeListFilteringStrategy.INSTANCE);
        result2.add(new StructureFilteringStrategy(this.myProject));
        boolean addNameFilter = false;
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider<CommittedChangeList, ?> provider2 = vcs.getCommittedChangesProvider();
            if (provider2 == null) continue;
            addNameFilter = true;
            for (ChangeListColumn column : provider2.getColumns()) {
                if (!ChangeListColumn.isCustom(column)) continue;
                result2.add(new ColumnFilteringStrategy(column, provider2.getClass()));
            }
        }
        if (addNameFilter) {
            result2.add(new ColumnFilteringStrategy(ChangeListColumn.NAME, CommittedChangesProvider.class));
        }
        ArrayList<ChangeListFilteringStrategy> arrayList = result2;
        if (arrayList == null) {
            SelectFilteringAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreselectCondition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7 -> new IllegalStateException(string2);
        };
    }

    private final class SetFilteringAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListFilteringStrategy myStrategy;

        private SetFilteringAction(ChangeListFilteringStrategy strategy) {
            if (strategy == null) {
                SetFilteringAction.$$$reportNull$$$0(0);
            }
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetFilteringAction.$$$reportNull$$$0(1);
            }
            if (!NoneChangeListFilteringStrategy.INSTANCE.equals(SelectFilteringAction.this.myPreviousSelection)) {
                SelectFilteringAction.this.myBrowser.removeFilteringStrategy(SelectFilteringAction.this.myPreviousSelection.getKey());
            }
            if (!NoneChangeListFilteringStrategy.INSTANCE.equals(this.myStrategy)) {
                SelectFilteringAction.this.myBrowser.setFilteringStrategy(this.myStrategy);
            }
            SelectFilteringAction.this.myPreviousSelection = this.myStrategy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction$SetFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

