/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0017\u001a\u00020\u00182\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u00182\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/MoveChangesHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "Lorg/jetbrains/annotations/NotNull;", "changedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChangedFiles", "()Ljava/util/List;", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "isEmpty", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "unversionedFiles", "getUnversionedFiles", "addChanges", "", "", "([Lcom/intellij/openapi/vcs/changes/Change;)V", "addChangesForFiles", "files", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "addChangesUnder", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nMoveChangesToAnotherListAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n18#2:197\n18#2:199\n26#3:198\n26#3:200\n1#4:201\n*S KotlinDebug\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesHandler\n*L\n159#1:197\n163#1:199\n159#1:198\n163#1:200\n*E\n"})
final class MoveChangesHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final ChangeListManager changeListManager;
    @NotNull
    private final List<VirtualFile> unversionedFiles;
    @NotNull
    private final List<VirtualFile> changedFiles;
    @NotNull
    private final List<Change> changes;

    public MoveChangesHandler(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        this.changeListManager = changeListManager;
        this.unversionedFiles = new ArrayList();
        this.changedFiles = new ArrayList();
        this.changes = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<VirtualFile> getUnversionedFiles() {
        return this.unversionedFiles;
    }

    @NotNull
    public final List<VirtualFile> getChangedFiles() {
        return this.changedFiles;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    public final boolean isEmpty() {
        return this.changes.isEmpty() && this.unversionedFiles.isEmpty();
    }

    public final void addChanges(@Nullable Change[] changes2) {
        Collection collection = this.changes;
        Object[] $this$orEmpty$iv = changes2;
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new Change[]{};
        }
        CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
    }

    public final void addChangesForFiles(@Nullable VirtualFile[] files2) {
        VirtualFile[] $this$orEmpty$iv = files2;
        boolean $i$f$orEmpty = false;
        VirtualFile[] virtualFileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            virtualFileArray = new VirtualFile[]{};
        }
        for (VirtualFile file : virtualFileArray) {
            Change change = this.changeListManager.getChange(file);
            if (change == null) {
                FileStatus status;
                Intrinsics.checkNotNullExpressionValue((Object)this.changeListManager.getStatus(file), (String)"getStatus(...)");
                if (Intrinsics.areEqual((Object)FileStatus.UNKNOWN, (Object)status)) {
                    this.unversionedFiles.add(file);
                    this.changedFiles.add(file);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)FileStatus.NOT_CHANGED, (Object)status) || !file.isDirectory()) continue;
                FilePath filePath = VcsUtil.getFilePath(file);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                this.addChangesUnder(filePath);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath(change);
            if (afterPath != null && afterPath.isDirectory()) {
                this.addChangesUnder(afterPath);
                continue;
            }
            this.changes.add(change);
            this.changedFiles.add(file);
        }
    }

    private final void addChangesUnder(FilePath path2) {
        for (Change change : this.changeListManager.getChangesIn(path2)) {
            VirtualFile it;
            VirtualFile file;
            Intrinsics.checkNotNull((Object)change);
            this.changes.add(change);
            FilePath filePath = ChangesUtil.getAfterPath(change);
            Object object = file = filePath != null ? filePath.getVirtualFile() : null;
            if (file == null) continue;
            boolean bl = false;
            this.changedFiles.add(it);
        }
    }
}

