/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ExtendableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreatePatchFromChangesAction
extends ExtendableAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CreatePatchFromChangesAction.class);
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_DIALOG = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Dialog.ExtensionProvider");
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME_CLIPBOARD = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.Clipboard.ExtensionProvider");
    private final boolean mySilentClipboard;

    private CreatePatchFromChangesAction(boolean silentClipboard) {
        super(silentClipboard ? EP_NAME_CLIPBOARD : EP_NAME_DIALOG);
        this.mySilentClipboard = silentClipboard;
    }

    public void defaultUpdate(@NotNull AnActionEvent e) {
        int changelistNum;
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(0);
        }
        Object[] changes2 = (Change[])e.getData(VcsDataKeys.CHANGES);
        JBIterable unversioned = JBIterable.from((Iterable)((Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
        if (ArrayUtil.isEmpty((Object[])changes2) && unversioned.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List<ShelvedChangeList> shelveChangelists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        int n = changelistNum = changeLists == null ? 0 : changeLists.length;
        if ((changelistNum += shelveChangelists.size()) > 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    public void defaultActionPerformed(@NotNull AnActionEvent e) {
        CreatePatchCommitExecutor.PatchBuilder patchBuilder;
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Object[] changes2 = (Change[])e.getData(VcsDataKeys.CHANGES);
        JBIterable unversioned = JBIterable.from((Iterable)((Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
        ArrayList allChanges = new ArrayList();
        if (changes2 != null) {
            ContainerUtil.addAll(allChanges, (Object[])changes2);
        }
        ContainerUtil.addAll(allChanges, (Iterable)unversioned.map(path2 -> new Change(null, new CurrentContentRevision((FilePath)path2))));
        if (allChanges.isEmpty()) {
            return;
        }
        String commitMessage = CreatePatchFromChangesAction.extractCommitMessage(e);
        project2 = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        ShelvedChangeList shelvedChangeList = (ShelvedChangeList)ContainerUtil.getOnlyItem(ShelvedChangesViewManager.getShelvedLists(e.getDataContext()));
        if (shelvedChangeList != null) {
            boolean entireList = ContainerUtil.getOnlyItem(ShelvedChangesViewManager.getExactlySelectedLists(e.getDataContext())) != null;
            List<String> selectedPaths = entireList ? ContainerUtil.emptyList() : ShelvedChangesViewManager.getSelectedShelvedChangeNames(e.getDataContext());
            patchBuilder = new CreatePatchCommitExecutor.ShelfPatchBuilder(project2, shelvedChangeList, selectedPaths);
        } else {
            patchBuilder = new CreatePatchCommitExecutor.DefaultPatchBuilder(project2);
        }
        CreatePatchFromChangesAction.createPatch(project2, commitMessage, allChanges, this.mySilentClipboard, patchBuilder);
    }

    @Nullable
    private static String extractCommitMessage(@NotNull AnActionEvent e) {
        String message2;
        if (e == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(2);
        }
        if ((message2 = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE)) != null) {
            return message2;
        }
        List<ShelvedChangeList> shelvedChangeLists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        if (!shelvedChangeLists.isEmpty()) {
            return shelvedChangeLists.get((int)0).DESCRIPTION;
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0) {
            return changeLists[0].getComment();
        }
        return null;
    }

    public static void createPatch(@Nullable Project project2, @Nullable String commitMessage, @NotNull List<? extends Change> changes2) {
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(3);
        }
        CreatePatchFromChangesAction.createPatch(project2, commitMessage, changes2, false);
    }

    public static void createPatch(@Nullable Project project2, @Nullable String commitMessage, @NotNull List<? extends Change> changes2, boolean silentClipboard) {
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(4);
        }
        project2 = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        CreatePatchCommitExecutor.DefaultPatchBuilder patchBuilder = new CreatePatchCommitExecutor.DefaultPatchBuilder(project2);
        CreatePatchFromChangesAction.createPatch(project2, commitMessage, changes2, silentClipboard, patchBuilder);
    }

    private static void createPatch(@NotNull Project project2, @Nullable String commitMessage, @NotNull List<? extends Change> changes2, boolean silentClipboard, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder) {
        if (project2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(5);
        }
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(6);
        }
        if (patchBuilder == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(7);
        }
        CommitContext commitContext = new CommitContext();
        if (silentClipboard) {
            CreatePatchFromChangesAction.createIntoClipboard(project2, changes2, commitMessage, patchBuilder, commitContext);
        } else {
            CreatePatchFromChangesAction.createWithDialog(project2, commitMessage, changes2, patchBuilder, commitContext);
        }
    }

    private static void createWithDialog(@NotNull Project project2, @Nullable String commitMessage, @NotNull List<? extends Change> changes2, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder, @NotNull CommitContext commitContext) {
        if (project2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(8);
        }
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(9);
        }
        if (patchBuilder == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(10);
        }
        if (commitContext == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(11);
        }
        CommitSession commitSession = CreatePatchCommitExecutor.createCommitSession(project2, patchBuilder, commitContext);
        String title2 = VcsBundle.message("action.name.create.patch", new Object[0]);
        if (!SessionDialog.configureCommitSession(project2, title2, commitSession, changes2, commitMessage)) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> commitSession.execute(changes2, commitMessage), VcsBundle.message("create.patch.commit.action.progress", new Object[0]), true, project2);
    }

    private static void createIntoClipboard(@NotNull Project project2, @NotNull List<? extends Change> changes2, @Nullable String commitMessage, @NotNull CreatePatchCommitExecutor.PatchBuilder patchBuilder, @NotNull CommitContext commitContext) {
        if (project2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(12);
        }
        if (changes2 == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(13);
        }
        if (patchBuilder == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(14);
        }
        if (commitContext == null) {
            CreatePatchFromChangesAction.$$$reportNull$$$0(15);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                Path baseDir2 = PatchWriter.calculateBaseDirForWritingPatch(project2, changes2);
                CreatePatchCommitExecutor.writePatchToClipboard(project2, baseDir2, changes2, commitMessage, false, false, patchBuilder, commitContext);
            }
            catch (VcsException | IOException exception) {
                LOG.warn("Can't create patch", (Throwable)exception);
                VcsNotifier.getInstance(project2).notifyWeakError("vcs.patch.creation.failed", VcsBundle.message("patch.creation.failed", new Object[0]), exception.getMessage());
            }
        }, VcsBundle.message("create.patch.commit.action.progress", new Object[0]), true, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchBuilder";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/CreatePatchFromChangesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCommitMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createPatch";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createWithDialog";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createIntoClipboard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Clipboard
    extends CreatePatchFromChangesAction {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends CreatePatchFromChangesAction {
        public Dialog() {
            super(false);
        }
    }
}

