/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.DiffRequestProcessorWithProducers;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.EditorTabPreviewEscapeAction;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000f\u0010 \u001a\t\u0018\u00010!\u00a2\u0006\u0002\b\"H$J\b\u0010#\u001a\u00020\u001fH$J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010(\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001fJ\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u001e\u0010-\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0/H\u0002J\u0016\u00100\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001fJ\b\u00101\u001a\u00020\u001fH\u0014J\b\u00102\u001a\u00020\u001fH\u0014J\b\u00103\u001a\u00020\u001fH\u0004J\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001fH\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001fH\u0002J\b\u00107\u001a\u00020\u001fH\u0016J\b\u00108\u001a\u00020\u001fH\u0014J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001fH\u0016R\"\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "escapeHandler", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "getEscapeHandler", "()Ljava/lang/Runnable;", "setEscapeHandler", "(Ljava/lang/Runnable;)V", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "previewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPreviewFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updatePreviewProcessor", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "getUpdatePreviewProcessor", "()Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "updatePreviewQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "closePreview", "", "ensureHasContent", "", "getCurrentName", "", "Lorg/jetbrains/annotations/Nls;", "hasContent", "installDoubleClickHandler", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "installEnterKeyHandler", "installListeners", "isOpenEditorDiffPreviewWithSingleClick", "installNextDiffActionOn", "component", "Ljavax/swing/JComponent;", "installSelectionChangedHandler", "handler", "Lkotlin/Function0;", "installSelectionHandler", "isPreviewOnDoubleClickAllowed", "isPreviewOnEnterAllowed", "isPreviewOpen", "openPreview", "requestFocus", "openPreviewEditor", "performDiffAction", "skipPreviewUpdate", "updatePreview", "fromModelRefresh", "Companion", "EditorTabDiffPreviewVirtualFile", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabPreviewBase\n+ 2 Runnable.kt\nkotlinx/coroutines/RunnableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n17#2:251\n1#3:252\n*S KotlinDebug\n*F\n+ 1 EditorTabPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabPreviewBase\n*L\n126#1:251\n*E\n"})
public abstract class EditorTabPreviewBase
implements DiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final MergingUpdateQueue updatePreviewQueue;
    @Nullable
    private Runnable escapeHandler;

    /*
     * WARNING - void declaration
     */
    public EditorTabPreviewBase(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        void $this$updatePreviewQueue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project2;
        this.parentDisposable = parentDisposable;
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("updatePreviewQueue", 100, true, null, this.parentDisposable);
        EditorTabPreviewBase editorTabPreviewBase = this;
        boolean bl = false;
        $this$updatePreviewQueue_u24lambda_u240.setRestartTimerOnAdd(true);
        editorTabPreviewBase.updatePreviewQueue = mergingUpdateQueue;
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase._init_$lambda$1(this));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    protected abstract DiffPreviewUpdateProcessor getUpdatePreviewProcessor();

    @NotNull
    protected abstract VirtualFile getPreviewFile();

    @Nullable
    public final Runnable getEscapeHandler() {
        return this.escapeHandler;
    }

    public final void setEscapeHandler(@Nullable Runnable runnable) {
        this.escapeHandler = runnable;
    }

    public final void installListeners(@NotNull ChangesTree tree2, boolean isOpenEditorDiffPreviewWithSingleClick) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        this.installDoubleClickHandler(tree2);
        this.installEnterKeyHandler(tree2);
        if (isOpenEditorDiffPreviewWithSingleClick) {
            DumbService.Companion.getInstance(this.project).smartInvokeLater(() -> EditorTabPreviewBase.installListeners$lambda$2(this, tree2));
        } else {
            this.installSelectionHandler(tree2, false);
        }
    }

    public final void installSelectionHandler(@NotNull ChangesTree tree2, boolean isOpenEditorDiffPreviewWithSingleClick) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        this.installSelectionChangedHandler(tree2, (Function0<Unit>)((Function0)new Function0<Unit>(isOpenEditorDiffPreviewWithSingleClick, this){
            final /* synthetic */ boolean $isOpenEditorDiffPreviewWithSingleClick;
            final /* synthetic */ EditorTabPreviewBase this$0;
            {
                this.$isOpenEditorDiffPreviewWithSingleClick = $isOpenEditorDiffPreviewWithSingleClick;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$isOpenEditorDiffPreviewWithSingleClick) {
                    if (!this.this$0.openPreview(false)) {
                        this.this$0.closePreview();
                    }
                } else {
                    this.this$0.updatePreview(false);
                }
            }
        }));
    }

    public final void installNextDiffActionOn(@NotNull JComponent component2) {
        DumbAwareAction dumbAwareAction;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        DumbAwareAction $this$installNextDiffActionOn_u24lambda_u244 = dumbAwareAction = DumbAwareAction.create(arg_0 -> EditorTabPreviewBase.installNextDiffActionOn$lambda$3((Function1)new Function1<AnActionEvent, Unit>(this){
            final /* synthetic */ EditorTabPreviewBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AnActionEvent it) {
                this.this$0.openPreview(true);
            }
        }, arg_0));
        boolean bl = false;
        $this$installNextDiffActionOn_u24lambda_u244.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        $this$installNextDiffActionOn_u24lambda_u244.registerCustomShortcutSet(component2, this.parentDisposable);
    }

    protected boolean isPreviewOnDoubleClickAllowed() {
        return true;
    }

    protected boolean isPreviewOnEnterAllowed() {
        return true;
    }

    private final void installDoubleClickHandler(ChangesTree tree2) {
        Processor<? super MouseEvent> oldDoubleClickHandler = tree2.getDoubleClickHandler();
        Processor newDoubleClickHandler = arg_0 -> EditorTabPreviewBase.installDoubleClickHandler$lambda$5(tree2, this, oldDoubleClickHandler, arg_0);
        tree2.setDoubleClickHandler((Processor<? super MouseEvent>)newDoubleClickHandler);
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase.installDoubleClickHandler$lambda$6(tree2, oldDoubleClickHandler));
    }

    private final void installEnterKeyHandler(ChangesTree tree2) {
        Processor<? super KeyEvent> oldEnterKeyHandler = tree2.getEnterKeyHandler();
        Processor newEnterKeyHandler = arg_0 -> EditorTabPreviewBase.installEnterKeyHandler$lambda$7(this, oldEnterKeyHandler, arg_0);
        tree2.setEnterKeyHandler((Processor<? super KeyEvent>)newEnterKeyHandler);
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase.installEnterKeyHandler$lambda$8(tree2, oldEnterKeyHandler));
    }

    private final void installSelectionChangedHandler(ChangesTree tree2, Function0<Unit> handler2) {
        boolean $i$f$Runnable = false;
        tree2.addSelectionListener(new Runnable(this, handler2){
            final /* synthetic */ EditorTabPreviewBase this$0;
            final /* synthetic */ Function0 $handler$inlined;
            {
                this.this$0 = editorTabPreviewBase;
                this.$handler$inlined = function0;
            }

            public final void run() {
                boolean bl = false;
                EditorTabPreviewBase.access$getUpdatePreviewQueue$p(this.this$0).queue((Update)DisposableUpdate.createDisposable((Disposable)((Disposable)EditorTabPreviewBase.access$getUpdatePreviewQueue$p(this.this$0)), (Object)this.this$0, (Runnable)new Runnable(this.this$0, (Function0<Unit>)this.$handler$inlined){
                    final /* synthetic */ EditorTabPreviewBase this$0;
                    final /* synthetic */ Function0<Unit> $handler;
                    {
                        this.this$0 = $receiver;
                        this.$handler = $handler;
                    }

                    public final void run() {
                        if (!this.this$0.skipPreviewUpdate()) {
                            this.$handler.invoke();
                        }
                    }
                }));
            }
        }, (Disposable)this.updatePreviewQueue);
    }

    @Nullable
    protected abstract String getCurrentName();

    protected abstract boolean hasContent();

    protected boolean skipPreviewUpdate() {
        return ToolWindowManager.Companion.getInstance(this.project).isEditorComponentActive();
    }

    public void updatePreview(boolean fromModelRefresh) {
        if (this.isPreviewOpen()) {
            this.getUpdatePreviewProcessor().refresh(false);
        } else {
            this.getUpdatePreviewProcessor().clear();
        }
    }

    protected final boolean isPreviewOpen() {
        return FileEditorManager.getInstance((Project)this.project).isFileOpenWithRemotes(this.getPreviewFile());
    }

    @Override
    public void closePreview() {
        DiffPreview.Companion.closePreviewFile(this.project, this.getPreviewFile());
        this.getUpdatePreviewProcessor().clear();
    }

    @Override
    public boolean openPreview(boolean requestFocus2) {
        if (!this.ensureHasContent()) {
            return false;
        }
        return this.openPreviewEditor(requestFocus2);
    }

    private final boolean ensureHasContent() {
        this.getUpdatePreviewProcessor().refresh(false);
        return this.hasContent();
    }

    private final boolean openPreviewEditor(boolean requestFocus2) {
        Runnable runnable = this.escapeHandler;
        if (runnable != null) {
            Runnable handler2 = runnable;
            boolean bl = false;
            Companion.registerEscapeHandler(this.getPreviewFile(), handler2);
        }
        Companion.openPreview(this.project, this.getPreviewFile(), requestFocus2);
        return true;
    }

    @Override
    public boolean performDiffAction() {
        if (!this.ensureHasContent()) {
            return false;
        }
        if (ExternalDiffTool.isEnabled()) {
            DiffRequestProcessorWithProducers processorWithProducers;
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            DiffRequestProcessorWithProducers diffRequestProcessorWithProducers = processorWithProducers = diffPreviewUpdateProcessor instanceof DiffRequestProcessorWithProducers ? (DiffRequestProcessorWithProducers)((Object)diffPreviewUpdateProcessor) : null;
            if (processorWithProducers != null) {
                ListSelection<? extends DiffRequestProducer> diffProducers = processorWithProducers.collectDiffProducers(true);
                if (diffProducers != null && diffProducers.isEmpty()) {
                    DiffRequestProducer diffRequestProducer;
                    List list2;
                    ListSelection<? extends DiffRequestProducer> listSelection = processorWithProducers.collectDiffProducers(false);
                    if (listSelection != null && (list2 = listSelection.getList()) != null && (diffRequestProducer = (DiffRequestProducer)CollectionsKt.firstOrNull((List)list2)) != null) {
                        DiffRequestProducer it = diffRequestProducer;
                        boolean bl = false;
                        v1 = ListSelection.createSingleton((Object)it);
                    } else {
                        v1 = diffProducers = null;
                    }
                }
                if (Companion.showExternalToolIfNeeded(this.project, diffProducers)) {
                    return true;
                }
            }
        }
        return this.openPreviewEditor(true);
    }

    private static final void _init_$lambda$1(EditorTabPreviewBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getPreviewFile().putUserData(DiffVirtualFileBase.ESCAPE_HANDLER, null);
    }

    private static final void installListeners$lambda$2(EditorTabPreviewBase this$0, ChangesTree $tree) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$tree), (String)"$tree");
        if (Disposer.isDisposed((Disposable)((Disposable)this$0.updatePreviewQueue))) {
            return;
        }
        this$0.installSelectionHandler($tree, true);
    }

    private static final void installNextDiffActionOn$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean installDoubleClickHandler$lambda$5(ChangesTree $tree, EditorTabPreviewBase this$0, Processor $oldDoubleClickHandler, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tree), (String)"$tree");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JTree jTree = (JTree)((Object)$tree);
        Intrinsics.checkNotNull((Object)e);
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)jTree, (MouseEvent)e)) {
            return false;
        }
        if (this$0.isPreviewOnDoubleClickAllowed()) {
            if (this$0.performDiffAction()) return true;
        }
        Processor processor2 = $oldDoubleClickHandler;
        if (processor2 == null) return false;
        if (!processor2.process((Object)e)) return false;
        return true;
    }

    private static final void installDoubleClickHandler$lambda$6(ChangesTree $tree, Processor $oldDoubleClickHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tree), (String)"$tree");
        $tree.setDoubleClickHandler((Processor<? super MouseEvent>)$oldDoubleClickHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean installEnterKeyHandler$lambda$7(EditorTabPreviewBase this$0, Processor $oldEnterKeyHandler, KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isPreviewOnEnterAllowed()) {
            if (this$0.performDiffAction()) return true;
        }
        Processor processor2 = $oldEnterKeyHandler;
        if (processor2 == null) return false;
        if (!processor2.process((Object)e)) return false;
        return true;
    }

    private static final void installEnterKeyHandler$lambda$8(ChangesTree $tree, Processor $oldEnterKeyHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tree), (String)"$tree");
        $tree.setEnterKeyHandler((Processor<? super KeyEvent>)$oldEnterKeyHandler);
    }

    public static final /* synthetic */ MergingUpdateQueue access$getUpdatePreviewQueue$p(EditorTabPreviewBase $this) {
        return $this.updatePreviewQueue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\"\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0015\u0018\u00010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase$Companion;", "", "()V", "openPreview", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Z)[Lcom/intellij/openapi/fileEditor/FileEditor;", "registerEscapeHandler", "", "handler", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "showExternalToolIfNeeded", "diffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileEditor[] openPreview(@NotNull Project project2, @NotNull VirtualFile file, boolean focusEditor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return DiffEditorTabFilesManager.Companion.getInstance(project2).showDiffFile(file, focusEditor);
        }

        public final void registerEscapeHandler(@NotNull VirtualFile file, @NotNull Runnable handler2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            file.putUserData(DiffVirtualFileBase.ESCAPE_HANDLER, (Object)new EditorTabPreviewEscapeAction(handler2));
        }

        public final boolean showExternalToolIfNeeded(@Nullable Project project2, @Nullable ListSelection<? extends DiffRequestProducer> diffProducers) {
            if (diffProducers == null || diffProducers.isEmpty()) {
                return false;
            }
            List list2 = diffProducers.getExplicitSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExplicitSelection(...)");
            List producers = list2;
            return ExternalDiffTool.showIfNeeded((Project)project2, (List)producers, (DiffDialogHints)DiffDialogHints.DEFAULT);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B*\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0013\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase$EditorTabDiffPreviewVirtualFile;", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "diffProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "updatePreviewProcessor", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "tabNameProvider", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/diff/impl/DiffRequestProcessor;Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;Lkotlin/jvm/functions/Function0;)V", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorTabPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabPreviewBase$EditorTabDiffPreviewVirtualFile\n+ 2 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,250:1\n17#2:251\n*S KotlinDebug\n*F\n+ 1 EditorTabPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabPreviewBase$EditorTabDiffPreviewVirtualFile\n*L\n198#1:251\n*E\n"})
    public static final class EditorTabDiffPreviewVirtualFile
    extends PreviewDiffVirtualFile {
        public EditorTabDiffPreviewVirtualFile(@NotNull DiffRequestProcessor diffProcessor, @NotNull DiffPreviewUpdateProcessor updatePreviewProcessor, @NotNull Function0<String> tabNameProvider) {
            Intrinsics.checkNotNullParameter((Object)diffProcessor, (String)"diffProcessor");
            Intrinsics.checkNotNullParameter((Object)updatePreviewProcessor, (String)"updatePreviewProcessor");
            Intrinsics.checkNotNullParameter(tabNameProvider, (String)"tabNameProvider");
            super(new EditorTabDiffPreviewProvider(diffProcessor, tabNameProvider));
            boolean $i$f$Runnable = false;
            diffProcessor.putContextUserData(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE, (Object)new Runnable(updatePreviewProcessor){
                final /* synthetic */ DiffPreviewUpdateProcessor $updatePreviewProcessor$inlined;
                {
                    this.$updatePreviewProcessor$inlined = diffPreviewUpdateProcessor;
                }

                public final void run() {
                    boolean bl = false;
                    this.$updatePreviewProcessor$inlined.clear();
                }
            });
        }
    }
}

