/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListScheduler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DelayedNotificator
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance(DelayedNotificator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeListManagerImpl myManager;
    @NotNull
    private final ChangeListScheduler myScheduler;

    public DelayedNotificator(@NotNull Project project2, @NotNull ChangeListManagerImpl manager, @NotNull ChangeListScheduler scheduler) {
        if (project2 == null) {
            DelayedNotificator.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DelayedNotificator.$$$reportNull$$$0(1);
        }
        if (scheduler == null) {
            DelayedNotificator.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myManager = manager;
        this.myScheduler = scheduler;
    }

    public void callNotify(ChangeListCommand command) {
        this.myScheduler.submit(() -> {
            try {
                command.doNotify(this.getMulticaster());
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        });
    }

    @Override
    public void changeListAdded(ChangeList list2) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListAdded(list2));
    }

    @Override
    public void changesRemoved(Collection<? extends Change> changes2, ChangeList fromList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesRemoved(changes2, fromList));
    }

    @Override
    public void changesAdded(Collection<? extends Change> changes2, ChangeList toList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesAdded(changes2, toList));
    }

    @Override
    public void changeListRemoved(ChangeList list2) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListRemoved(list2));
    }

    @Override
    public void changeListChanged(ChangeList list2) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListChanged(list2));
    }

    @Override
    public void changeListRenamed(ChangeList list2, String oldName) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListRenamed(list2, oldName));
    }

    @Override
    public void changeListDataChanged(@NotNull ChangeList list2) {
        if (list2 == null) {
            DelayedNotificator.$$$reportNull$$$0(3);
        }
        this.myScheduler.submit(() -> this.getMulticaster().changeListDataChanged(list2));
    }

    @Override
    public void changeListCommentChanged(ChangeList list2, String oldComment) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListCommentChanged(list2, oldComment));
    }

    @Override
    public void changesMoved(Collection<? extends Change> changes2, ChangeList fromList, ChangeList toList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesMoved(changes2, fromList, toList));
    }

    @Override
    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
        this.defaultListChanged(oldDefaultList, newDefaultList, false);
    }

    @Override
    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
        this.myScheduler.submit(() -> this.getMulticaster().defaultListChanged(oldDefaultList, newDefaultList, automatic));
    }

    @Override
    public void changedFileStatusChanged(boolean upToDate) {
        this.myScheduler.submit(() -> this.getMulticaster().changedFileStatusChanged(upToDate));
    }

    @Override
    public void unchangedFileStatusChanged(boolean upToDate) {
        this.myScheduler.submit(() -> this.getMulticaster().unchangedFileStatusChanged(upToDate));
    }

    @Override
    public void changeListUpdateDone() {
        this.myScheduler.submit(() -> this.getMulticaster().changeListUpdateDone());
    }

    @Override
    public void allChangeListsMappingsChanged() {
        this.myScheduler.submit(() -> this.getMulticaster().allChangeListsMappingsChanged());
    }

    @Override
    public void changeListAvailabilityChanged() {
        this.myScheduler.submit(() -> this.getMulticaster().changeListAvailabilityChanged());
    }

    public void changeListsForFileChanged(@NotNull FilePath path2, @NotNull Set<String> removedChangeListsIds, @NotNull Set<String> addedChangeListsIds) {
        if (path2 == null) {
            DelayedNotificator.$$$reportNull$$$0(4);
        }
        if (removedChangeListsIds == null) {
            DelayedNotificator.$$$reportNull$$$0(5);
        }
        if (addedChangeListsIds == null) {
            DelayedNotificator.$$$reportNull$$$0(6);
        }
        this.myScheduler.submit(() -> {
            LocalChangeList changeList;
            if (!this.myManager.areChangeListsEnabled()) {
                return;
            }
            Change change = this.myManager.getChange(path2);
            if (change == null) {
                return;
            }
            List<Change> changes2 = Collections.singletonList(change);
            for (String listId : removedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                this.getMulticaster().changesRemoved(changes2, changeList);
            }
            for (String listId : addedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                this.getMulticaster().changesAdded(changes2, changeList);
            }
        });
    }

    @NotNull
    private ChangeListListener getMulticaster() {
        ChangeListListener changeListListener = (ChangeListListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ChangeListListener.TOPIC);
        if (changeListListener == null) {
            DelayedNotificator.$$$reportNull$$$0(7);
        }
        return changeListListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedChangeListsIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedChangeListsIds";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/DelayedNotificator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/DelayedNotificator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMulticaster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeListDataChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeListsForFileChanged";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }
}

