/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.actions.EditAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ConversionResultImpl
implements ConversionResult {
    public static final ConversionResultImpl CONVERSION_NOT_NEEDED = new ConversionResultImpl(false, false, false);
    public static final ConversionResultImpl CONVERSION_CANCELED = new ConversionResultImpl(true, true, false);
    public static final ConversionResultImpl ERROR_OCCURRED = new ConversionResultImpl(true, false, true);
    private final boolean myConversionNeeded;
    private final boolean myConversionCanceled;
    private final boolean myErrorOccurred;
    private final Set<Path> myChangedFiles;
    private final Set<Path> myCreatedFiles;

    private ConversionResultImpl(boolean conversionNeeded, boolean conversionCanceled, boolean errorOccurred) {
        this.myChangedFiles = new HashSet<Path>();
        this.myCreatedFiles = new HashSet<Path>();
        this.myConversionNeeded = conversionNeeded;
        this.myConversionCanceled = conversionCanceled;
        this.myErrorOccurred = errorOccurred;
    }

    ConversionResultImpl(@NotNull List<ConversionRunner> converters) {
        if (converters == null) {
            ConversionResultImpl.$$$reportNull$$$0(0);
        }
        this.myChangedFiles = new HashSet<Path>();
        this.myCreatedFiles = new HashSet<Path>();
        this.myConversionNeeded = true;
        this.myConversionCanceled = false;
        this.myErrorOccurred = false;
        for (ConversionRunner converter : converters) {
            converter.collectAffectedFiles(this.myChangedFiles);
            this.myCreatedFiles.addAll(converter.getCreatedFiles());
        }
    }

    public boolean conversionNotNeeded() {
        return !this.myConversionNeeded;
    }

    public boolean openingIsCanceled() {
        return this.myConversionCanceled || this.myErrorOccurred;
    }

    public void postStartupActivity(@NotNull Project project2) {
        List<VirtualFile> createdFiles;
        Application app;
        if (project2 == null) {
            ConversionResultImpl.$$$reportNull$$$0(1);
        }
        if ((app = ApplicationManager.getApplication()).isHeadlessEnvironment() || app.isUnitTestMode()) {
            return;
        }
        List<VirtualFile> changedFiles = ConversionResultImpl.findVirtualFiles(this.myChangedFiles);
        if (!changedFiles.isEmpty()) {
            EditAction.editFilesAndShowErrors(project2, changedFiles);
        }
        if (!ConversionResultImpl.containsFilesUnderVcs(createdFiles = ConversionResultImpl.findVirtualFiles(this.myCreatedFiles), project2)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Collection<VirtualFile> selected = AbstractVcsHelper.getInstance(project2).selectFilesToProcess(createdFiles, VcsBundle.message("dialog.title.files.created", new Object[0]), VcsBundle.message("label.select.files.to.be.added.to.version.control", new Object[0]), null, null, VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION);
            if (selected != null && !selected.isEmpty()) {
                ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project2);
                changeListManager.addUnversionedFiles(null, new ArrayList<VirtualFile>(selected));
            }
        }, ModalityState.nonModal(), project2.getDisposed());
    }

    private static boolean containsFilesUnderVcs(@NotNull List<? extends VirtualFile> files2, Project project2) {
        if (files2 == null) {
            ConversionResultImpl.$$$reportNull$$$0(2);
        }
        if (files2.isEmpty()) {
            return false;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance(project2);
        for (VirtualFile virtualFile : files2) {
            if (projectLevelVcsManager.getVcsFor(virtualFile) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> findVirtualFiles(@NotNull Collection<? extends Path> files2) {
        if (files2 == null) {
            ConversionResultImpl.$$$reportNull$$$0(3);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        for (Path path2 : files2) {
            VirtualFile element = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(path2);
            if (element == null) continue;
            result2.add(element);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            ConversionResultImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/impl/ConversionResultImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/impl/ConversionResultImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsFilesUnderVcs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFiles";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

