/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.utils.LocalHistoryLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class StructuralChange
extends Change {
    protected final String myPath;

    protected StructuralChange(long id, String path2) {
        super(id);
        this.myPath = path2;
    }

    protected StructuralChange(DataInput in) throws IOException {
        super(in);
        this.myPath = DataStreamUtil.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataStreamUtil.writeString(out, this.myPath);
    }

    protected void removeEntry(Entry e) {
        e.getParent().removeChild(e);
    }

    public String getPath() {
        return this.myPath;
    }

    public String getOldPath() {
        return this.myPath;
    }

    public abstract void revertOn(RootEntry var1, boolean var2);

    protected void cannotRevert(String path2, boolean warnOnFileNotFound) {
        if (warnOnFileNotFound) {
            LocalHistoryLog.LOG.warn("cannot revert " + this.getClass().getSimpleName() + "->file not found: " + path2);
        }
    }

    public String revertPath(String path2) {
        if (Paths.equals(this.getPath(), this.getOldPath())) {
            return path2;
        }
        String relative = Paths.relativeIfUnder(path2, this.myPath);
        if (relative == null) {
            return path2;
        }
        if (relative.isEmpty()) {
            return this.getOldPath();
        }
        return Paths.appended(this.getOldPath(), relative);
    }

    @Override
    public boolean affectsPath(String path2) {
        for (String each : this.getAffectedPaths()) {
            if (!Paths.isParentOrChild(each, path2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean affectsProject(String projectId) {
        return false;
    }

    @Override
    public boolean affectsMatching(Pattern pattern2) {
        for (String each : this.getAffectedPaths()) {
            if (!pattern2.matcher(Paths.getNameOf(each)).matches()) continue;
            return true;
        }
        return false;
    }

    protected String[] getAffectedPaths() {
        return new String[]{this.myPath};
    }

    @Override
    public boolean isCreationalFor(String path2) {
        return false;
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.myPath;
    }
}

