/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ActivityId;
import com.intellij.history.ByteContent;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.Content;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001:\u0001RB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0011J\u001e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*J#\u0010+\u001a\u00020\u00112\r\u0010,\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0007J\u0010\u00100\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\nH\u0002J\u0006\u00103\u001a\u00020\u0011J \u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u001f\u001a\u00020 2\u0006\u00108\u001a\u00020\u0016H\u0002J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u00106\u001a\u000207J\u0016\u0010<\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010=\u001a\u00020 J\u0010\u0010>\u001a\u00020?2\u0006\u0010\u0015\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020@H\u0007J#\u0010B\u001a\u00020?2\u000b\u0010,\u001a\u00070 \u00a2\u0006\u0002\b-2\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020EJ\u001b\u0010F\u001a\u00020?2\u000b\u0010,\u001a\u00070 \u00a2\u0006\u0002\b-2\u0006\u0010C\u001a\u00020 J\u0016\u0010G\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010H\u001a\u00020'J\u000e\u0010I\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fJ\u0016\u0010J\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010K\u001a\u00020 J.\u0010L\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u0010M\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020'J.\u0010P\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u0010Q\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade;", "", "changeList", "Lcom/intellij/history/core/ChangeList;", "(Lcom/intellij/history/core/ChangeList;)V", "changeListInTests", "getChangeListInTests", "()Lcom/intellij/history/core/ChangeList;", "changes", "", "Lcom/intellij/history/core/changes/ChangeSet;", "getChanges$intellij_platform_lvcs_impl", "()Ljava/lang/Iterable;", "listeners", "", "Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "accept", "", "v", "Lcom/intellij/history/core/changes/ChangeVisitor;", "addChange", "c", "Lcom/intellij/history/core/changes/Change;", "addChangeInTests", "Lcom/intellij/history/core/changes/StructuralChange;", "addListener", "l", "parent", "Lcom/intellij/openapi/Disposable;", "beginChangeSet", "contentChanged", "path", "", "oldContent", "Lcom/intellij/history/core/Content;", "oldTimestamp", "", "created", "isDirectory", "", "deleted", "deletedEntry", "Lcom/intellij/history/core/tree/Entry;", "endChangeSet", "name", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "fireChangeAdded", "fireChangeSetFinished", "changeSet", "forceBeginChangeSet", "getByteContentBefore", "Lcom/intellij/history/ByteContent;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "change", "getRecentChanges", "", "Lcom/intellij/history/core/revisions/RecentChange;", "moved", "oldParent", "putLabel", "Lcom/intellij/history/core/LabelImpl;", "Lcom/intellij/history/core/changes/PutLabelChange;", "putLabelInTests", "putSystemLabel", "projectId", "color", "", "putUserLabel", "readOnlyStatusChanged", "oldStatus", "removeListener", "renamed", "oldName", "revertUpToChange", "changeId", "revertTarget", "warnOnFileNotFound", "revertUpToChangeSet", "changeSetId", "Listener", "intellij.platform.lvcs.impl"})
public class LocalHistoryFacade {
    @NotNull
    private final ChangeList changeList;
    @NotNull
    private final List<Listener> listeners;

    public LocalHistoryFacade(@NotNull ChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        this.changeList = changeList;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
    }

    @TestOnly
    @NotNull
    public final ChangeList getChangeListInTests() {
        return this.changeList;
    }

    @NotNull
    public final Iterable<ChangeSet> getChanges$intellij_platform_lvcs_impl() {
        return this.changeList.iterChanges();
    }

    public final void beginChangeSet() {
        this.changeList.beginChangeSet();
    }

    public final void forceBeginChangeSet() {
        ChangeSet lastChangeSet = this.changeList.forceBeginChangeSet();
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name, @Nullable ActivityId activityId) {
        ChangeSet lastChangeSet = this.changeList.endChangeSet(name, activityId);
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    public static /* synthetic */ void endChangeSet$default(LocalHistoryFacade localHistoryFacade, String string2, ActivityId activityId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endChangeSet");
        }
        if ((n & 2) != 0) {
            activityId = null;
        }
        localHistoryFacade.endChangeSet(string2, activityId);
    }

    public final void created(@NotNull String path2, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.addChange(isDirectory ? (CreateEntryChange)new CreateDirectoryChange(this.changeList.nextId(), path2) : (CreateEntryChange)new CreateFileChange(this.changeList.nextId(), path2));
    }

    public final void contentChanged(@NotNull String path2, @NotNull Content oldContent, long oldTimestamp) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        this.addChange(new ContentChange(this.changeList.nextId(), path2, oldContent, oldTimestamp));
    }

    public final void renamed(@NotNull String path2, @NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        this.addChange(new RenameChange(this.changeList.nextId(), path2, oldName));
    }

    public final void readOnlyStatusChanged(@NotNull String path2, boolean oldStatus) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.addChange(new ROStatusChange(this.changeList.nextId(), path2, oldStatus));
    }

    public final void moved(@NotNull String path2, @NotNull String oldParent) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldParent, (String)"oldParent");
        this.addChange(new MoveChange(this.changeList.nextId(), path2, oldParent));
    }

    public final void deleted(@NotNull String path2, @NotNull Entry deletedEntry) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)deletedEntry, (String)"deletedEntry");
        this.addChange(new DeleteChange(this.changeList.nextId(), path2, deletedEntry));
    }

    @NotNull
    public final LabelImpl putSystemLabel(@NotNull String name, @NotNull String projectId, int color2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutSystemLabelChange(this.changeList.nextId(), name, projectId, color2));
    }

    @NotNull
    public final LabelImpl putUserLabel(@NotNull String name, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutLabelChange(this.changeList.nextId(), name, projectId));
    }

    private final void addChange(Change c) {
        this.beginChangeSet();
        this.changeList.addChange(c);
        this.fireChangeAdded(c);
        LocalHistoryFacade.endChangeSet$default(this, null, null, 2, null);
    }

    @TestOnly
    public final void addChangeInTests(@NotNull StructuralChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.addChange(c);
    }

    private final LabelImpl putLabel(PutLabelChange c) {
        this.addChange(c);
        return new LabelImpl(c, this){
            final /* synthetic */ PutLabelChange $c;
            final /* synthetic */ LocalHistoryFacade this$0;
            {
                this.$c = $c;
                this.this$0 = $receiver;
            }

            public long getLabelChangeId() {
                return this.$c.getId();
            }

            @NotNull
            public ByteContent getByteContent(@NotNull RootEntry root, @NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                return LocalHistoryFacade.access$getByteContentBefore(this.this$0, root, path2, this.$c);
            }
        };
    }

    @TestOnly
    public final void putLabelInTests(@NotNull PutLabelChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.putLabel(c);
    }

    private final ByteContent getByteContentBefore(RootEntry root, String path2, Change change) {
        RootEntry rootEntry = root.copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry, (String)"copy(...)");
        RootEntry rootCopy = rootEntry;
        String newPath = this.revertUpToChange(rootCopy, change.getId(), path2, false, false);
        Entry entry2 = rootCopy.findEntry(newPath);
        if (entry2 == null) {
            return new ByteContent(false, null);
        }
        if (entry2.isDirectory()) {
            return new ByteContent(true, null);
        }
        return new ByteContent(false, entry2.getContent().getBytesIfAvailable());
    }

    @NotNull
    public final List<RecentChange> getRecentChanges(@NotNull RootEntry root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        List result2 = new ArrayList();
        for (ChangeSet c : this.changeList.iterChanges()) {
            if (c.isContentChangeOnly() || c.isLabelOnly() || c.getName() == null) continue;
            ChangeRevision before2 = new ChangeRevision(this, root, "", c, true);
            ChangeRevision after2 = new ChangeRevision(this, root, "", c, false);
            result2.add(new RecentChange(before2, after2));
            if (result2.size() < 20) continue;
            break;
        }
        return result2;
    }

    public final void accept(@NotNull ChangeVisitor v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.changeList.accept(v);
    }

    @NotNull
    public final String revertUpToChangeSet(@NotNull RootEntry root, long changeSetId, @NotNull String path2, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String entryPath = path2;
        for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            if (!revertTarget && changeSet.getId() == changeSetId) break;
            List<Change> list2 = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list2)) {
                if (!(change instanceof StructuralChange) || !change.affectsPath(entryPath)) continue;
                ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
            }
            if (!revertTarget || changeSet.getId() != changeSetId) continue;
            break;
        }
        return entryPath;
    }

    @NotNull
    public final String revertUpToChange(@NotNull RootEntry root, long changeId, @NotNull String path2, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String entryPath = path2;
        block0: for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            List<Change> list2 = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list2)) {
                if (!revertTarget && change.getId() == changeId) break block0;
                if (change instanceof StructuralChange && change.affectsPath(entryPath)) {
                    ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                    Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
                }
                if (!revertTarget || change.getId() != changeId) continue;
                break block0;
            }
        }
        return entryPath;
    }

    public final void addListener(@NotNull Listener l, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> LocalHistoryFacade.addListener$lambda$0(this, l));
        }
    }

    public final void removeListener(@NotNull Listener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    private final void fireChangeAdded(Change c) {
        for (Listener each : this.listeners) {
            each.changeAdded(c);
        }
    }

    private final void fireChangeSetFinished(ChangeSet changeSet) {
        for (Listener each : this.listeners) {
            each.changeSetFinished(changeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name) {
        LocalHistoryFacade.endChangeSet$default(this, name, null, 2, null);
    }

    private static final void addListener$lambda$0(LocalHistoryFacade this$0, Listener $l) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$l, (String)"$l");
        this$0.listeners.remove($l);
    }

    public static final /* synthetic */ ByteContent access$getByteContentBefore(LocalHistoryFacade $this, RootEntry root, String path2, Change change) {
        return $this.getByteContentBefore(root, path2, change);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "", "()V", "changeAdded", "", "c", "Lcom/intellij/history/core/changes/Change;", "changeSetFinished", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "intellij.platform.lvcs.impl"})
    public static abstract class Listener {
        public void changeAdded(@NotNull Change c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        }

        public void changeSetFinished(@NotNull ChangeSet changeSet) {
            Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        }
    }
}

