/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLinkedTextComponent
extends JLabel {
    private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    @NotNull
    @NlsSafe
    private final String myTextBefore;
    @NotNull
    @NlsSafe
    private final String myTextAfter;
    @NotNull
    @NlsSafe
    private String myHandledLink;
    @Nullable
    private final VcsLinkListener myLinkListener;
    private boolean mySelected;
    private boolean myUnderlined;
    private boolean myTransparent;

    public VcsLinkedTextComponent(@NotNull String text2, @Nullable VcsLinkListener listener2) {
        if (text2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(0);
        }
        Matcher aMatcher = HREF_PATTERN.matcher(text2);
        if (aMatcher.find()) {
            this.myTextBefore = text2.substring(0, aMatcher.start());
            this.myHandledLink = aMatcher.group(2);
            this.myTextAfter = text2.substring(aMatcher.end());
        } else {
            this.myTextBefore = text2;
            this.myHandledLink = "";
            this.myTextAfter = "";
        }
        this.myLinkListener = listener2;
    }

    public void updateLinkText(@NotNull @Nls String text2) {
        if (text2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(1);
        }
        this.myHandledLink = text2;
    }

    public void fireOnClick(@NotNull DefaultMutableTreeNode relatedNode, @NotNull MouseEvent event) {
        if (relatedNode == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(2);
        }
        if (event == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(3);
        }
        if (this.myLinkListener != null) {
            this.myLinkListener.hyperlinkActivated(relatedNode, event);
        }
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer2) {
        if (renderer2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(4);
        }
        boolean isActive = this.mySelected || this.myUnderlined;
        SimpleTextAttributes linkTextAttributes = isActive ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
        isActive = isActive || !this.myTransparent;
        SimpleTextAttributes wrappedTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer2, SimpleTextAttributes.REGULAR_ATTRIBUTES, isActive);
        if (!StringUtil.isEmptyOrSpaces((String)this.myTextBefore)) {
            renderer2.append(this.myTextBefore, wrappedTextAttributes);
            renderer2.append(" ");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myHandledLink)) {
            renderer2.append(this.myHandledLink, PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer2, linkTextAttributes, isActive), (Object)this);
        }
        renderer2.append(this.myTextAfter, wrappedTextAttributes);
    }

    public void setUnderlined(boolean underlined) {
        this.myUnderlined = underlined;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    public void setTransparent(boolean transparent) {
        this.myTransparent = transparent;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = this.myTextBefore + this.myHandledLink + this.myTextAfter;
        if (string2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsLinkedTextComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsLinkedTextComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fireOnClick";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

