/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.list.search;

import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.codereview.list.search.AbstractListLoadingListener;
import com.intellij.collaboration.ui.codereview.list.search.ChooserPopupUtilKt;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BQ\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b0\u0007\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/collaboration/ui/codereview/list/search/ListLoadingListener;", "T", "", "Lcom/intellij/collaboration/ui/codereview/list/search/AbstractListLoadingListener;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "itemsFlow", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Result;", "", "list", "Lcom/intellij/ui/components/JBList;", "listModel", "Lcom/intellij/ui/CollectionListModel;", "errorPresenter", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/Flow;Lcom/intellij/ui/components/JBList;Lcom/intellij/ui/CollectionListModel;Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;)V", "onFailure", "", "exception", "onSuccess", "items", "intellij.platform.collaborationTools"})
final class ListLoadingListener<T>
extends AbstractListLoadingListener<T> {
    @NotNull
    private final CoroutineScope parentScope;
    @NotNull
    private final Flow<Result<List<T>>> itemsFlow;
    @NotNull
    private final JBList<?> list;
    @NotNull
    private final CollectionListModel<T> listModel;
    @Nullable
    private final ErrorStatusPresenter.Text<Throwable> errorPresenter;

    public ListLoadingListener(@NotNull CoroutineScope parentScope, @NotNull Flow<? extends Result<? extends List<? extends T>>> itemsFlow, @NotNull JBList<?> list2, @NotNull CollectionListModel<T> listModel, @Nullable ErrorStatusPresenter.Text<Throwable> errorPresenter) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter(itemsFlow, (String)"itemsFlow");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        super(parentScope, itemsFlow, list2);
        this.parentScope = parentScope;
        this.itemsFlow = itemsFlow;
        this.list = list2;
        this.listModel = listModel;
        this.errorPresenter = errorPresenter;
    }

    @Override
    public void onSuccess(@NotNull List<? extends T> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        int selected = this.list.getSelectedIndex();
        if (items2.size() > this.listModel.getSize()) {
            List<? extends T> newList = items2.subList(this.listModel.getSize(), items2.size());
            this.listModel.addAll(this.listModel.getSize(), newList);
        }
        if (selected != -1) {
            this.list.setSelectedIndex(selected);
        }
    }

    @Override
    public void onFailure(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        ChooserPopupUtilKt.access$showErrorOnPopupFailure(exception, this.errorPresenter, this.list);
    }
}

