/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.editor;

import com.intellij.diff.util.Range;
import com.intellij.openapi.diff.LineStatusMarkerColorScheme;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/ReviewInEditorUtil;", "", "()V", "REVIEW_CHANGES_STATUS_COLOR", "Lcom/intellij/ui/JBColor;", "getREVIEW_CHANGES_STATUS_COLOR", "()Lcom/intellij/ui/JBColor;", "REVIEW_STATUS_MARKER_COLOR_SCHEME", "Lcom/intellij/openapi/diff/LineStatusMarkerColorScheme;", "getREVIEW_STATUS_MARKER_COLOR_SCHEME", "()Lcom/intellij/openapi/diff/LineStatusMarkerColorScheme;", "transferLineFromAfter", "", "ranges", "", "Lcom/intellij/diff/util/Range;", "line", "approximate", "", "(Ljava/util/List;IZ)Ljava/lang/Integer;", "transferLineToAfter", "intellij.platform.collaborationTools"})
public final class ReviewInEditorUtil {
    @NotNull
    public static final ReviewInEditorUtil INSTANCE = new ReviewInEditorUtil();
    @NotNull
    private static final JBColor REVIEW_CHANGES_STATUS_COLOR;
    @NotNull
    private static final LineStatusMarkerColorScheme REVIEW_STATUS_MARKER_COLOR_SCHEME;

    private ReviewInEditorUtil() {
    }

    @NotNull
    public final JBColor getREVIEW_CHANGES_STATUS_COLOR() {
        return REVIEW_CHANGES_STATUS_COLOR;
    }

    @NotNull
    public final LineStatusMarkerColorScheme getREVIEW_STATUS_MARKER_COLOR_SCHEME() {
        return REVIEW_STATUS_MARKER_COLOR_SCHEME;
    }

    public final int transferLineToAfter(@NotNull List<Range> ranges, int line) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        if (ranges.isEmpty()) {
            return line;
        }
        int result2 = line;
        for (Range range : ranges) {
            int n = range.start1;
            boolean bl = line < range.end1 ? n <= line : false;
            if (bl) {
                return RangesKt.coerceAtLeast((int)(range.end2 - 1), (int)0);
            }
            if (range.end1 > line) {
                return result2;
            }
            int length1 = range.end1 - range.start1;
            int length2 = range.end2 - range.start2;
            result2 += length2 - length1;
        }
        return result2;
    }

    @Nullable
    public final Integer transferLineFromAfter(@NotNull List<Range> ranges, int line, boolean approximate) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        if (ranges.isEmpty()) {
            return line;
        }
        int result2 = line;
        for (Range range : ranges) {
            if (line < range.start2) {
                return result2;
            }
            int n = range.start2;
            boolean bl = line < range.end2 ? n <= line : false;
            if (bl) {
                return approximate ? Integer.valueOf(range.end1) : null;
            }
            int length1 = range.end1 - range.start1;
            int length2 = range.end2 - range.start2;
            result2 -= length2 - length1;
        }
        return result2;
    }

    public static /* synthetic */ Integer transferLineFromAfter$default(ReviewInEditorUtil reviewInEditorUtil, List list2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return reviewInEditorUtil.transferLineFromAfter(list2, n, bl);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Review.Editor.Line.Status.Marker", (Color)((Color)new JBColor(16294111, 9060725)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        REVIEW_CHANGES_STATUS_COLOR = jBColor;
        REVIEW_STATUS_MARKER_COLOR_SCHEME = new LineStatusMarkerColorScheme(){

            @NotNull
            public Color getColor(@NotNull Editor editor, byte type2) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return (Color)ReviewInEditorUtil.INSTANCE.getREVIEW_CHANGES_STATUS_COLOR();
            }

            @NotNull
            public Color getIgnoredBorderColor(@NotNull Editor editor, byte type2) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return (Color)ReviewInEditorUtil.INSTANCE.getREVIEW_CHANGES_STATUS_COLOR();
            }

            @NotNull
            public Color getErrorStripeColor(byte type2) {
                return (Color)ReviewInEditorUtil.INSTANCE.getREVIEW_CHANGES_STATUS_COLOR();
            }
        };
    }
}

