/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.actions;

import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;

public final class EmmetEditPointUtil {
    public static void moveForward(Editor editor, PsiFile file) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor, file, editor.getCaretModel().getOffset(), 1);
    }

    public static void moveBackward(Editor editor, PsiFile file) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor, file, editor.getCaretModel().getOffset(), -1);
    }

    private static void moveToNextPoint(Editor editor, PsiFile file, int offset, int inc) {
        Document doc2 = editor.getDocument();
        TemplateLanguageFileViewProvider provider2 = (TemplateLanguageFileViewProvider)ObjectUtils.tryCast((Object)file.getViewProvider(), TemplateLanguageFileViewProvider.class);
        Language additionalLanguage = provider2 != null ? provider2.getTemplateDataLanguage() : null;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(doc2);
        for (int i = offset + inc; i < doc2.getTextLength() && i >= 0; i += inc) {
            PsiElement current = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)i);
            if (EmmetEditPointUtil.checkAndMove(editor, doc2, i, current)) {
                return;
            }
            if (additionalLanguage == null || !EmmetEditPointUtil.checkAndMove(editor, doc2, i, current = provider2.findElementAt(i, additionalLanguage))) continue;
            return;
        }
    }

    private static boolean checkAndMove(Editor editor, Document doc2, int offset, PsiElement current) {
        if (current == null) {
            return false;
        }
        if (current.getParent() instanceof XmlText) {
            int line = doc2.getLineNumber(offset);
            int lineStart = doc2.getLineStartOffset(line);
            int lineEnd = doc2.getLineEndOffset(line);
            CharSequence text2 = doc2.getCharsSequence().subSequence(lineStart, lineEnd);
            if (StringUtil.isEmptyOrSpaces((CharSequence)text2) && EmmetEditPointUtil.moveCaret(editor, current, lineEnd)) {
                return true;
            }
        } else if (EmmetEditPointUtil.isEmptyEditPoint(current) && EmmetEditPointUtil.moveCaret(editor, current, current.getTextRange().getStartOffset())) {
            return true;
        }
        return false;
    }

    private static boolean moveCaret(Editor editor, PsiElement current, int offset) {
        CaretModel caretModel = (editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)current.getContainingFile())).getCaretModel();
        if (caretModel.getOffset() == offset) {
            return false;
        }
        caretModel.moveToOffset(offset);
        Caret caret = caretModel.getCurrentCaret();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (caret == caretModel.getPrimaryCaret()) {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
        return true;
    }

    private static boolean isEmptyEditPoint(PsiElement element) {
        IElementType type2 = element.getNode().getElementType();
        if (type2 == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
            return prev != null && prev.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
        }
        if (type2 == XmlTokenType.XML_END_TAG_START || type2 == XmlTokenType.XML_START_TAG_START) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
            return prev != null && prev.getNode().getElementType() == XmlTokenType.XML_TAG_END;
        }
        return false;
    }
}

